/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm.req;

import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.comm.rsp.BSolidyneOverrideResponse;
import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.solidyne.solidyne.comm.rsp.SolidyneMessageFactory;
import com.solidyne.solidyne.identify.BSolidynePointId;
import com.solidyne.solidyne.izac.point.BSolidyneIzacProxyExt;
import com.solidyne.solidyne.izac.point.BSolidyneIzacUniversalInputPoint;
import com.solidyne.solidyne.point.BSolidyneAbstractProxyExt;
import com.solidyne.solidyne.point.BSolidyneProxyExt;
import com.solidyne.solidyne.point.BSolidyneUniversalInputPoint;
import com.solidyne.solidyne.util.Utils;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.point.BDdfProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.log.Log;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSolidyneOverrideRequest
extends BDdfRequest {
    public static final Type TYPE;
    public static byte ACTION_CANCEL;
    public static byte ACTION_TRIGGER;
    public static byte ACTION_QUERY;
    protected int targetDevice;
    protected byte targetPoint_h;
    protected byte targetPoint_l;
    protected byte action;
    protected BDdfProxyExt myProxy;
    static /* synthetic */ Class class$com$solidyne$solidyne$comm$req$BSolidyneOverrideRequest;

    public Type getType() {
        return TYPE;
    }

    public byte[] toByteArray() {
        byte[] byArray;
        BSolidyneNetwork bSolidyneNetwork = (BSolidyneNetwork)this.myProxy.getNetwork();
        int n = ((BSolidyneCommunicator)bSolidyneNetwork.getCommunicator()).getHostDeviceAddress();
        int n2 = 0;
        if (this.targetDevice < 256) {
            byte[] byArray2 = new byte[10];
            byArray2[0] = 127;
            byArray2[3] = 99;
            byArray2[5] = 3;
            byArray = byArray2;
            byArray[1] = (byte)n;
            byArray[2] = (byte)this.targetDevice;
        } else {
            byte[] byArray3 = new byte[15];
            byArray3[0] = 127;
            byArray3[3] = 99;
            byArray3[5] = 8;
            byArray = byArray3;
            byArray[7] = 0;
            byArray[8] = (byte)n;
            byArray[9] = (byte)(this.targetDevice >> 8 & 0xFF);
            byArray[10] = (byte)(this.targetDevice & 0xFF);
            n2 = 5;
        }
        byArray[6 + n2] = this.targetPoint_h;
        byArray[7 + n2] = this.targetPoint_l;
        byArray[8 + n2] = this.action;
        byte by = 0;
        int n3 = 0;
        while (n3 < byArray.length - 1) {
            by = (byte)(by + byArray[n3]);
            ++n3;
        }
        byArray[byArray.length - 1] = by;
        return Utils.escapeMessage(byArray);
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        try {
            BSolidyneResponse bSolidyneResponse = SolidyneMessageFactory.makeMessage(iDdfDataFrame);
            if (bSolidyneResponse.msgType == 227) {
                Log.getLog((String)"solidyne").trace("RECEIVED OVRD REQUEST RESPONSE!!!");
                BSolidyneOverrideResponse bSolidyneOverrideResponse = (BSolidyneOverrideResponse)bSolidyneResponse;
                if (bSolidyneOverrideResponse.orgDevice == this.targetDevice && bSolidyneOverrideResponse.targetPoint[0] == this.targetPoint_h && bSolidyneOverrideResponse.targetPoint[1] == this.targetPoint_l) {
                    BNumericPoint bNumericPoint;
                    if (this.myProxy instanceof BSolidyneProxyExt) {
                        bNumericPoint = (BSolidyneUniversalInputPoint)this.myProxy.getParentPoint();
                        boolean bl = false;
                        if (bSolidyneOverrideResponse.status != 0) {
                            bl = true;
                        }
                        bNumericPoint.setOverridden(new BStatusBoolean(bl));
                        bNumericPoint.setRemainingOverrideDuration(new BStatusNumeric((double)bSolidyneOverrideResponse.remainingMin));
                    }
                    if (this.myProxy instanceof BSolidyneIzacProxyExt) {
                        bNumericPoint = (BSolidyneIzacUniversalInputPoint)this.myProxy.getParentPoint();
                        boolean bl = false;
                        if (bSolidyneOverrideResponse.status != 0) {
                            bl = true;
                        }
                        bNumericPoint.setOverridden(new BStatusBoolean(bl));
                        bNumericPoint.setRemainingOverrideDuration(new BStatusNumeric((double)bSolidyneOverrideResponse.remainingMin));
                    }
                }
                return bSolidyneOverrideResponse;
            }
        }
        catch (Exception exception) {
            throw new DdfResponseException();
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BSolidyneOverrideRequest() {
    }

    public BSolidyneOverrideRequest(BSolidyneAbstractProxyExt bSolidyneAbstractProxyExt, int n, byte by) {
        BSolidynePointId bSolidynePointId = (BSolidynePointId)bSolidyneAbstractProxyExt.getPointId();
        this.myProxy = bSolidyneAbstractProxyExt;
        this.targetDevice = n;
        byte[] byArray = Utils.makeAddress(n, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_UI_OVRD);
        this.targetPoint_h = byArray[0];
        this.targetPoint_l = byArray[1];
        this.action = by;
    }

    public BSolidyneOverrideRequest(BSolidyneIzacProxyExt bSolidyneIzacProxyExt, int n, byte by) {
        BSolidynePointId bSolidynePointId = (BSolidynePointId)bSolidyneIzacProxyExt.getPointId();
        this.myProxy = bSolidyneIzacProxyExt;
        this.targetDevice = n;
        byte[] byArray = Utils.makeAddress(n, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_UI_OVRD);
        this.targetPoint_h = byArray[0];
        this.targetPoint_l = byArray[1];
        this.action = by;
    }

    static {
        Class clazz = class$com$solidyne$solidyne$comm$req$BSolidyneOverrideRequest;
        if (clazz == null) {
            clazz = class$com$solidyne$solidyne$comm$req$BSolidyneOverrideRequest = BSolidyneOverrideRequest.class("[Lcom.solidyne.solidyne.comm.req.BSolidyneOverrideRequest;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ACTION_CANCEL = 0;
        ACTION_TRIGGER = 1;
        ACTION_QUERY = (byte)-1;
    }
}

