/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm;

import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.comm.BSolidyneReceiver;
import com.solidyne.solidyne.comm.BSolidyneUnsolicitedMgr;
import com.solidyne.solidyne.comm.req.BSolidyneSetRequest;
import com.tridium.ddf.clock.BDdfScheduler;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.BIDdfWriteRequest;
import com.tridium.ddfSerial.comm.singleTransaction.BDdfSerialSitCommunicator;
import java.io.StringWriter;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Worker;

public class BSolidyneCommunicator
extends BDdfSerialSitCommunicator {
    public static final Property receiver = BSolidyneCommunicator.newProperty((int)0, (BValue)new BSolidyneReceiver(), null);
    public static final Property unsolicitedMgr = BSolidyneCommunicator.newProperty((int)0, (BValue)new BSolidyneUnsolicitedMgr(), null);
    public static final Property lastUnsolicitedMsg = BSolidyneCommunicator.newProperty((int)65537, (BValue)BAbsTime.make(), null);
    public static final Property transmitWindowStart = BSolidyneCommunicator.newProperty((int)0, (int)1000, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Property transmitWindowEnd = BSolidyneCommunicator.newProperty((int)0, (int)9000, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Property inactivityTimeout = BSolidyneCommunicator.newProperty((int)0, (int)60000, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Property hostDeviceAddress = BSolidyneCommunicator.newProperty((int)0, (int)253, (BFacets)BFacets.make((String[])new String[]{"min", "max"}, (BIDataValue[])new BInteger[]{BInteger.make((int)1), BInteger.make((int)255)}));
    public static final Type TYPE = Sys.loadType(BSolidyneCommunicator.class);
    private int writesInThisWindow = 0;

    public BDdfReceiver getReceiver() {
        return (BDdfReceiver)this.get(receiver);
    }

    public void setReceiver(BDdfReceiver v) {
        this.set(receiver, (BValue)v, null);
    }

    public BSolidyneUnsolicitedMgr getUnsolicitedMgr() {
        return (BSolidyneUnsolicitedMgr)this.get(unsolicitedMgr);
    }

    public void setUnsolicitedMgr(BSolidyneUnsolicitedMgr v) {
        this.set(unsolicitedMgr, (BValue)v, null);
    }

    public BAbsTime getLastUnsolicitedMsg() {
        return (BAbsTime)this.get(lastUnsolicitedMsg);
    }

    public void setLastUnsolicitedMsg(BAbsTime v) {
        this.set(lastUnsolicitedMsg, (BValue)v, null);
    }

    public int getTransmitWindowStart() {
        return this.getInt(transmitWindowStart);
    }

    public void setTransmitWindowStart(int v) {
        this.setInt(transmitWindowStart, v, null);
    }

    public int getTransmitWindowEnd() {
        return this.getInt(transmitWindowEnd);
    }

    public void setTransmitWindowEnd(int v) {
        this.setInt(transmitWindowEnd, v, null);
    }

    public int getInactivityTimeout() {
        return this.getInt(inactivityTimeout);
    }

    public void setInactivityTimeout(int v) {
        this.setInt(inactivityTimeout, v, null);
    }

    public int getHostDeviceAddress() {
        return this.getInt(hostDeviceAddress);
    }

    public void setHostDeviceAddress(int v) {
        this.setInt(hostDeviceAddress, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected boolean grantAccess(BIDdfRequest ddfRequest) {
        long now = BAbsTime.make().getMillis();
        long timeSinceLastMsg = now - this.getLastUnsolicitedMsg().getMillis();
        Log.getLog((String)"solidyne").trace("Outgoing message: " + ddfRequest.getType().toString());
        Log.getLog((String)"solidyne").trace("Time since last message: " + timeSinceLastMsg);
        if (timeSinceLastMsg < (long)this.getTransmitWindowStart() || timeSinceLastMsg > (long)this.getTransmitWindowEnd()) {
            if (timeSinceLastMsg > (long)this.getInactivityTimeout() && this.getParent().asComponent() instanceof BSolidyneNetwork) {
                ((BSolidyneNetwork)this.getParent().asComponent()).flagUnresponsiveDevices(this.getInactivityTimeout());
            }
            return false;
        }
        if (timeSinceLastMsg > (long)this.getTransmitWindowEnd() && timeSinceLastMsg < (long)(this.getTransmitWindowEnd() + 1000) && this.writesInThisWindow > 0 && this.writesInThisWindow < 5) {
            Log.getLog((String)"solidyne").warning("Driver was only able to process " + this.writesInThisWindow + " writes during this window.");
        }
        this.writesInThisWindow = 0;
        Log.getLog((String)"solidyne").trace("Granting access");
        boolean toReturn = super.grantAccess(ddfRequest);
        if (toReturn) {
            Log.getLog((String)"solidyne").trace("REALLY Granting access");
            ++this.writesInThisWindow;
        }
        return super.grantAccess(ddfRequest);
    }

    protected void printWorkerState() {
        Worker w = this.communicationWorker;
        StringWriter s = new StringWriter();
        if (w.isRunning()) {
            Log.getLog((String)"solidyne").trace("CommunicationWorker for " + this.getNavOrd() + " is running.");
        } else {
            Log.getLog((String)"solidyne").trace("CommunicationWorker for " + this.getNavOrd() + " is NOT running.");
        }
    }

    protected String replaceAll(String s, String match, String repl) {
        String toReturn = s;
        while (toReturn.indexOf(match) > -1) {
            toReturn = toReturn.substring(0, toReturn.indexOf(match)) + repl + toReturn.substring(toReturn.indexOf(match) + match.length());
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requeue(BIDdfRequest ddfRequest) {
        if (ddfRequest instanceof BSolidyneSetRequest) {
            Log.getLog((String)"Solidyne_writeRequeuing").trace("Requeueing > Type: " + ddfRequest.getClass() + ", Device: " + ddfRequest.getDeviceId() + ", Port: " + ((BSolidyneSetRequest)ddfRequest).getTargetAddress());
        } else {
            Log.getLog((String)"Solidyne_writeRequeuing").trace("Requeueing > Type: " + ddfRequest.getClass() + ", Device: " + ddfRequest.getDeviceId());
        }
        Vector vector = this.requeueList;
        synchronized (vector) {
            this.requeueList.addElement(ddfRequest);
        }
        if (this.requeueTicket == null || this.requeueTicket.isExpired()) {
            Log.getLog((String)"Solidyne").trace("SCHEDULING A REQUEUE FOR 1sec FROM NOW");
            this.requeueTicket = BDdfScheduler.INSTANCE.schedule((BComponent)this, 1000L, requeue, null);
        }
    }

    protected boolean coalesceWrites(BIDdfWriteRequest ddfRequest) {
        if (ddfRequest instanceof BSolidyneSetRequest) {
            Log.getLog((String)"Solidyne_coalesce").trace("Checking on coalesce for > Type: " + ddfRequest.getClass() + ", Device: " + ddfRequest.getDeviceId() + ", Port: " + ((BSolidyneSetRequest)ddfRequest).getTargetAddress());
        } else {
            Log.getLog((String)"Solidyne_coalesce").trace("*Checking on coalesce for > Type: " + ddfRequest.getClass() + ", Device: " + ddfRequest.getDeviceId());
        }
        return true;
    }

    protected boolean coalesceWrite(BIDdfWriteRequest ddfWriteRequest) {
        boolean toReturn = super.coalesceWrite(ddfWriteRequest);
        if (ddfWriteRequest instanceof BSolidyneSetRequest) {
            Log.getLog((String)"Solidyne_coalesce").trace("Coalescing for > Type: " + ddfWriteRequest.getClass() + ", Device: " + ddfWriteRequest.getDeviceId() + ", Port: " + ((BSolidyneSetRequest)ddfWriteRequest).getTargetAddress() + ". Returning " + toReturn);
        } else {
            Log.getLog((String)"Solidyne_coalesce").trace("*Coalescing > Type: " + ddfWriteRequest.getClass() + ", Device: " + ddfWriteRequest.getDeviceId() + ". Returning" + toReturn);
        }
        return toReturn;
    }

    protected void startWorker() {
        Worker thisWorker = this.getWorker();
        thisWorker.setTimeout(100);
        thisWorker.start(this.getWorkerThreadName());
    }

    public void doCommunicate(BIDdfRequest ddfRequest) {
        long t = System.currentTimeMillis();
        Log.getLog((String)"SolidyneCommRequests").trace("> Type: " + ddfRequest.getClass() + ", Device: " + ddfRequest.getDeviceId() + ", Time: " + t);
        super.doCommunicate(ddfRequest);
        Log.getLog((String)"SolidyneCommRequests").trace("< Type: " + ddfRequest.getClass() + ", Device: " + ddfRequest.getDeviceId() + ", Time: " + t);
    }
}

