/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm.req;

import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.comm.rsp.BSolidyneOverrideResponse;
import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.solidyne.solidyne.comm.rsp.SolidyneMessageFactory;
import com.solidyne.solidyne.identify.BSolidynePointId;
import com.solidyne.solidyne.izac.point.BSolidyneIzacProxyExt;
import com.solidyne.solidyne.izac.point.BSolidyneIzacUniversalInputPoint;
import com.solidyne.solidyne.point.BSolidyneAbstractProxyExt;
import com.solidyne.solidyne.point.BSolidyneProxyExt;
import com.solidyne.solidyne.point.BSolidyneUniversalInputPoint;
import com.solidyne.solidyne.util.Utils;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.point.BDdfProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.log.Log;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidyneOverrideRequest
extends BDdfRequest {
    public static final Type TYPE = Sys.loadType(BSolidyneOverrideRequest.class);
    protected int targetDevice;
    protected byte targetPoint_h;
    protected byte targetPoint_l;
    protected byte action;
    public static byte ACTION_CANCEL = 0;
    public static byte ACTION_TRIGGER = 1;
    public static byte ACTION_QUERY = (byte)-1;
    protected BDdfProxyExt myProxy;

    public Type getType() {
        return TYPE;
    }

    public BSolidyneOverrideRequest() {
    }

    public BSolidyneOverrideRequest(BSolidyneAbstractProxyExt prox, int targetDevice, byte action) {
        BSolidynePointId id = (BSolidynePointId)prox.getPointId();
        this.myProxy = prox;
        this.targetDevice = targetDevice;
        byte[] x = Utils.makeAddress(targetDevice, id.getPortNumber(), Utils.POINTTYPE_UI_OVRD);
        this.targetPoint_h = x[0];
        this.targetPoint_l = x[1];
        this.action = action;
    }

    public BSolidyneOverrideRequest(BSolidyneIzacProxyExt prox, int targetDevice, byte action) {
        BSolidynePointId id = (BSolidynePointId)prox.getPointId();
        this.myProxy = prox;
        this.targetDevice = targetDevice;
        byte[] x = Utils.makeAddress(targetDevice, id.getPortNumber(), Utils.POINTTYPE_UI_OVRD);
        this.targetPoint_h = x[0];
        this.targetPoint_l = x[1];
        this.action = action;
    }

    public byte[] toByteArray() {
        byte[] msg;
        BSolidyneNetwork net = (BSolidyneNetwork)this.myProxy.getNetwork();
        int hostAddress = ((BSolidyneCommunicator)net.getCommunicator()).getHostDeviceAddress();
        int extendedMsgOffset = 0;
        if (this.targetDevice < 256) {
            msg = new byte[]{127, 0, 0, 99, 0, 3, 0, 0, 0, 0};
            msg[1] = (byte)hostAddress;
            msg[2] = (byte)this.targetDevice;
        } else {
            msg = new byte[]{127, 0, 0, 99, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            msg[7] = 0;
            msg[8] = (byte)hostAddress;
            msg[9] = (byte)(this.targetDevice >> 8 & 0xFF);
            msg[10] = (byte)(this.targetDevice & 0xFF);
            extendedMsgOffset = 5;
        }
        msg[6 + extendedMsgOffset] = this.targetPoint_h;
        msg[7 + extendedMsgOffset] = this.targetPoint_l;
        msg[8 + extendedMsgOffset] = this.action;
        byte checksum = 0;
        for (int i = 0; i < msg.length - 1; ++i) {
            checksum = (byte)(checksum + msg[i]);
        }
        msg[msg.length - 1] = checksum;
        return Utils.escapeMessage(msg);
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        try {
            BSolidyneResponse msg = SolidyneMessageFactory.makeMessage(iDdfDataFrame);
            if (msg.msgType == 227) {
                Log.getLog((String)"solidyne").trace("RECEIVED OVRD REQUEST RESPONSE!!!");
                BSolidyneOverrideResponse resp = (BSolidyneOverrideResponse)msg;
                if (resp.orgDevice == this.targetDevice && resp.targetPoint[0] == this.targetPoint_h && resp.targetPoint[1] == this.targetPoint_l) {
                    BNumericPoint aiPoint;
                    if (this.myProxy instanceof BSolidyneProxyExt) {
                        aiPoint = (BSolidyneUniversalInputPoint)this.myProxy.getParentPoint();
                        aiPoint.setOverridden(new BStatusBoolean(resp.status != 0));
                        aiPoint.setRemainingOverrideDuration(new BStatusNumeric((double)resp.remainingMin));
                    }
                    if (this.myProxy instanceof BSolidyneIzacProxyExt) {
                        aiPoint = (BSolidyneIzacUniversalInputPoint)this.myProxy.getParentPoint();
                        aiPoint.setOverridden(new BStatusBoolean(resp.status != 0));
                        aiPoint.setRemainingOverrideDuration(new BStatusNumeric((double)resp.remainingMin));
                    }
                }
                return resp;
            }
        }
        catch (Exception exc) {
            throw new DdfResponseException();
        }
        return null;
    }
}

