/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm.rsp;

import com.solidyne.solidyne.identify.BSolidynePointId;
import com.solidyne.solidyne.identify.BSolidyneReadParams;
import com.solidyne.solidyne.point.BSolidyneAbstractProxyExt;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.rsp.BDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfReadResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BStringPoint;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidyneReadResponse
extends BDdfResponse
implements BIDdfReadResponse {
    public static final Type TYPE = Sys.loadType(BSolidyneReadResponse.class);
    private byte[] receiveBytes;
    private BSolidyneReadParams readParams;

    public Type getType() {
        return TYPE;
    }

    public BSolidyneReadResponse(IDdfDataFrame receiveFrame, BSolidyneReadParams readParams) throws DdfResponseException {
    }

    public BSolidyneReadResponse() {
    }

    public BStatusValue parseReadValue(IDdfReadable readableSource) {
        if (readableSource instanceof BSolidyneAbstractProxyExt) {
            BSolidyneAbstractProxyExt proxy = (BSolidyneAbstractProxyExt)readableSource;
            BSolidynePointId pointId = (BSolidynePointId)proxy.getPointId();
            return this.getReadValue(proxy, pointId);
        }
        return null;
    }

    private BStatusValue getReadValue(BSolidyneAbstractProxyExt proxy, BSolidynePointId pointId) {
        String sRawValue = "";
        int iRawValue = 0;
        iRawValue = sRawValue.equalsIgnoreCase("on") ? 1 : (sRawValue.equalsIgnoreCase("off") ? 0 : Integer.parseInt(sRawValue));
        BControlPoint controlPoint = proxy.getParentPoint();
        if (controlPoint instanceof BINumeric) {
            return new BStatusNumeric((double)iRawValue);
        }
        if (controlPoint instanceof BIBoolean) {
            return new BStatusBoolean(iRawValue > 0);
        }
        if (controlPoint instanceof BIEnum) {
            BStatusEnum e = ((BEnumPoint)controlPoint).getOut();
            return new BStatusEnum((BEnum)BDynamicEnum.make((int)Math.round(iRawValue), (BEnumRange)e.getValue().getRange()));
        }
        if (controlPoint instanceof BStringPoint) {
            return new BStatusString(sRawValue);
        }
        throw new IllegalStateException("Unsupported control point type: " + controlPoint.getType() + "! Please have my program fixed.");
    }
}

