/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm.rsp;

import com.solidyne.solidyne.comm.rsp.BSolidyneGetForcedResponse;
import com.solidyne.solidyne.comm.rsp.BSolidyneOverrideResponse;
import com.solidyne.solidyne.comm.rsp.BSolidynePublishedExtendedVirtualSensorValuesMessage;
import com.solidyne.solidyne.comm.rsp.BSolidynePublishedSensorValuesMessage;
import com.solidyne.solidyne.comm.rsp.BSolidynePutForcedResponse;
import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.solidyne.solidyne.comm.rsp.BSolidyneSetResponse;
import com.solidyne.solidyne.comm.rsp.BSolidyneUnrecognizedMessage;
import com.solidyne.solidyne.util.Utils;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.ndriver.io.TypedInputStream;
import java.io.InputStream;
import javax.baja.sys.BajaRuntimeException;

public class SolidyneMessageFactory {
    public static BSolidyneResponse makeMessage(IDdfDataFrame frame) throws Exception {
        byte[] unescapedFrame = Utils.unescapeMessage(frame.getFrameBytes(), frame.getFrameSize());
        try {
            TypedInputStream ti = new TypedInputStream(unescapedFrame, 0, unescapedFrame.length);
            ti.skip(3L);
            int msgType = ti.readUnsigned8();
            ti.reset();
            switch (msgType) {
                case 71: {
                    return new BSolidynePublishedSensorValuesMessage((InputStream)ti);
                }
                case 111: {
                    return new BSolidynePublishedExtendedVirtualSensorValuesMessage((InputStream)ti);
                }
                case 227: {
                    return new BSolidyneOverrideResponse((InputStream)ti);
                }
                case 229: {
                    return new BSolidyneSetResponse((InputStream)ti);
                }
                case 156: {
                    return new BSolidyneGetForcedResponse((InputStream)ti);
                }
                case 190: {
                    return new BSolidynePutForcedResponse((InputStream)ti);
                }
            }
            return new BSolidyneUnrecognizedMessage((InputStream)ti);
        }
        catch (Exception e) {
            throw new BajaRuntimeException("decode error:\n" + DrByteArrayUtil.toString((byte[])unescapedFrame, (int)unescapedFrame.length), (Throwable)e);
        }
    }
}

