/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.point;

import com.solidyne.solidyne.BSolidyneDevice;
import com.solidyne.solidyne.comm.req.BSolidyneGetForcedRequest;
import com.solidyne.solidyne.identify.BSolidyneDeviceId;
import com.solidyne.solidyne.identify.BSolidynePointId;
import com.solidyne.solidyne.identify.BSolidynePortTypeEnum;
import com.solidyne.solidyne.point.BISolidynePoint;
import com.solidyne.solidyne.point.BSolidyneProxyExt;
import com.tridium.ddf.comm.req.BIDdfRequest;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidyneDigitalOutputPoint
extends BBooleanWritable
implements BISolidynePoint {
    public static final Property force = BSolidyneDigitalOutputPoint.newProperty((int)8, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property forceState = BSolidyneDigitalOutputPoint.newProperty((int)8, (BValue)new BStatusBoolean(false), null);
    public static final Type TYPE = Sys.loadType(BSolidyneDigitalOutputPoint.class);

    public BStatusBoolean getForce() {
        return (BStatusBoolean)this.get(force);
    }

    public void setForce(BStatusBoolean v) {
        this.set(force, (BValue)v, null);
    }

    public BStatusBoolean getForceState() {
        return (BStatusBoolean)this.get(forceState);
    }

    public void setForceState(BStatusBoolean v) {
        this.set(forceState, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSolidyneDigitalOutputPoint() {
    }

    public BSolidyneDigitalOutputPoint(int deviceNum) {
        BSolidyneProxyExt ext = new BSolidyneProxyExt();
        ((BSolidynePointId)ext.getPointId()).setPortNumber(deviceNum);
        Property portNum = ((BSolidynePointId)ext.getPointId()).getProperty("portNumber");
        ((BSolidynePointId)ext.getPointId()).setFacets((Slot)portNum, BFacets.make((String[])new String[]{"min", "max"}, (BIDataValue[])new BInteger[]{BInteger.make((int)1), BInteger.make((int)8)}));
        BFacets deviceFacets = (BFacets)this.getFacets().newCopy();
        ext.setDeviceFacets(deviceFacets);
        this.setProxyExt((BAbstractProxyExt)ext);
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && ((BSolidyneProxyExt)this.getProxyExt()).isRunning() && property.equals(force)) {
            Log.getLog((String)"solidyne").trace("Force property of DO changed: " + this.getForce().toString());
            if (this.getForce().getStatus().isNull()) {
                this.doForce(false, false);
            } else {
                this.doForce(true, this.getForce().getBoolean());
            }
        }
    }

    public void doForce(boolean forceState, boolean forceValue) {
        BSolidyneProxyExt prox = (BSolidyneProxyExt)this.getProxyExt();
        BSolidyneDevice dev = (BSolidyneDevice)prox.getDdfDevice();
        int deviceId = ((BSolidyneDeviceId)dev.getDeviceId()).getUnitNumber();
        BSolidyneGetForcedRequest req = new BSolidyneGetForcedRequest(prox, deviceId, forceState, forceValue ? 1 : 0);
        prox.getDdfCommunicator().communicate((BIDdfRequest)req);
    }

    @Override
    public BSolidynePortTypeEnum getPortType() {
        return BSolidynePortTypeEnum.DigitalOut;
    }

    public void doAuto() {
        System.out.println("######  BSolidyneDigitalOutputPoint doAuto #######");
        this.setForceState(new BStatusBoolean(false));
        this.doForce(false, false);
        super.doAuto();
    }

    public void doEmergencyAuto() {
        System.out.println("######  BSolidyneDigitalOutputPoint doAuto #######");
        this.setForceState(new BStatusBoolean(false));
        this.doForce(false, false);
        super.doEmergencyAuto();
    }
}

