/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.ui;

import com.solidyne.solidyne.BSolidyneDevice;
import com.solidyne.solidyne.identify.BSolidyneDeviceId;
import com.solidyne.solidyne.izac.BSolidyneIzacDevice;
import com.tridium.ddf.ui.device.BDdfDeviceManager;
import com.tridium.ddf.ui.device.DdfDeviceController;
import java.util.ArrayList;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BSolidyneDeviceManager
extends BDdfDeviceManager {
    public static final Type TYPE = Sys.loadType(BSolidyneDeviceManager.class);
    static final Lexicon superLexicon = Lexicon.make(MgrController.class);
    static final UiLexicon lexicon = new UiLexicon(BSolidyneDeviceManager.class);
    public static final MgrTypeInfo SOLIDYNE_DEVICE = MgrTypeInfo.make((BComponent)new BSolidyneDevice());
    public static final MgrTypeInfo SOLIDYNE_IZAC_DEVICE = MgrTypeInfo.make((BComponent)new BSolidyneIzacDevice());

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new SolidyneDeviceModel(this);
    }

    protected MgrController makeController() {
        return new SolidyneDeviceController((BDeviceManager)this);
    }

    public class SolidyneDeviceController
    extends DdfDeviceController {
        public SolidyneDeviceController(BDeviceManager manager) {
            super(manager);
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            MgrTypeInfo[] types = this.getManager().getModel().getNewTypes();
            if (types == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown typeField = new BListDropDown();
            for (int i = 0; i < types.length; ++i) {
                typeField.getList().addItem((Object)types[i]);
            }
            typeField.setSelectedIndex(0);
            BTextField countField = new BTextField("1", 6);
            BTextField startAddressField = new BTextField("1", 6);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.type")));
            grid.add(null, (BValue)typeField);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.count")));
            grid.add(null, (BValue)countField);
            grid.add(null, (BValue)new BLabel("Start Address"));
            grid.add(null, (BValue)startAddressField);
            String title = this.newCommand.getLabel();
            MgrTypeInfo type = null;
            int count = 0;
            int startAddress = 1;
            boolean done = false;
            while (!done) {
                int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
                if (r == 2) {
                    return null;
                }
                type = (MgrTypeInfo)typeField.getSelectedItem();
                count = Integer.parseInt(countField.getText());
                startAddress = Integer.parseInt(startAddressField.getText());
                if (count > 247) {
                    BDialog.error((BWidget)this.getManager(), (Object)lexicon.getText("devManager.error.invalidCount"));
                    continue;
                }
                done = true;
            }
            MgrEdit edit = this.makeEdit(title);
            for (int i = 0; i < count; ++i) {
                if (startAddress < 1 || startAddress > 1000) {
                    startAddress = 1;
                }
                BComponent comp = ((SolidyneDeviceModel)this.getManager().getModel()).newInstance(type, startAddress);
                MgrEditRow row = new MgrEditRow(comp, null, types);
                edit.addRow(row);
                row.setDefaultName(SlotPath.escape((String)(type.getDisplayName() + startAddress)));
                ++startAddress;
            }
            return edit;
        }
    }

    public class SolidyneDeviceModel
    extends DeviceModel {
        SolidyneDeviceModel(BSolidyneDeviceManager mgr) {
            super((BDeviceManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Type(), new MgrColumn.Prop(BDevice.status), new MgrColumn.Prop(BDevice.health), new MgrColumn.PropPath(new Property[]{BSolidyneDevice.deviceId, BSolidyneDeviceId.unitNumber}, 1)};
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList<MgrTypeInfo> list = new ArrayList<MgrTypeInfo>();
            list.add(SOLIDYNE_DEVICE);
            list.add(SOLIDYNE_IZAC_DEVICE);
            return list.toArray(new MgrTypeInfo[list.size()]);
        }

        public BComponent newInstance(MgrTypeInfo type, int address) throws Exception {
            if (type.equals((Object)SOLIDYNE_DEVICE)) {
                BSolidyneDevice device = (BSolidyneDevice)this.newInstance(type);
                ((BSolidyneDeviceId)device.getDeviceId()).setUnitNumber(address);
                return device;
            }
            BSolidyneIzacDevice device = (BSolidyneIzacDevice)this.newInstance(type);
            ((BSolidyneDeviceId)device.getDeviceId()).setUnitNumber(address);
            return device;
        }
    }
}

