/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.ui;

import com.solidyne.solidyne.BSolidyneAbstractDevice;
import com.solidyne.solidyne.BSolidyneDevice;
import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.BSolidynePointDeviceExt;
import com.solidyne.solidyne.izac.BSolidyneIzacDevice;
import com.solidyne.solidyne.izac.BSolidyneIzacPointDeviceExt;
import com.solidyne.solidyne.izac.point.BSolidyneIzacAnalogOutputPoint;
import com.solidyne.solidyne.izac.point.BSolidyneIzacDigitalOutputPoint;
import com.solidyne.solidyne.izac.point.BSolidyneIzacUniversalInputPoint;
import com.solidyne.solidyne.izac.point.BSolidyneIzacVirtualPoint;
import com.solidyne.solidyne.point.BISolidynePoint;
import com.solidyne.solidyne.point.BSolidyneAnalogOutputPoint;
import com.solidyne.solidyne.point.BSolidyneDigitalOutputPoint;
import com.solidyne.solidyne.point.BSolidyneUniversalInputPoint;
import com.solidyne.solidyne.point.BSolidyneVirtualPoint;
import com.tridium.ddf.BDdfNetwork;
import com.tridium.ddf.ui.device.BDdfDeviceManager;
import com.tridium.ddf.ui.device.BDdfDeviceMgrAgent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.baja.agent.BIAgent;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.driver.BDeviceExt;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BDirectoryChooser;

public class BSolidyneDeviceMgrAgent
extends BDdfDeviceMgrAgent
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BSolidyneDeviceMgrAgent.class);

    public Type getType() {
        return TYPE;
    }

    public String getUiName() {
        return "Import";
    }

    public CommandArtifact doInvoke(BDdfDeviceManager deviceManager, BDdfNetwork net) {
        BSolidyneNetwork network = (BSolidyneNetwork)net;
        BDirectoryChooser dirChooser = BDirectoryChooser.make((BWidget)deviceManager);
        dirChooser.setTitle("Choose the Folder that holds the import files...");
        BOrd chosenOrd = dirChooser.show();
        if (chosenOrd == null) {
            return null;
        }
        BDirectory chosenDir = (BDirectory)chosenOrd.get();
        BIFile[] fileList = chosenDir.listFiles();
        BIFile networkFile = null;
        BIFile omitFile = null;
        BIFile nodeFile = null;
        BIFile aiFile = null;
        BIFile aoFile = null;
        BIFile doFile = null;
        BIFile viFile = null;
        BIFile outputFile = null;
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].getFileName().equalsIgnoreCase("network.csv")) {
                networkFile = fileList[i];
            }
            if (fileList[i].getFileName().equalsIgnoreCase("omit.csv")) {
                omitFile = fileList[i];
            }
            if (fileList[i].getFileName().equalsIgnoreCase("node.csv")) {
                nodeFile = fileList[i];
            }
            if (fileList[i].getFileName().equalsIgnoreCase("ai.csv")) {
                aiFile = fileList[i];
            }
            if (fileList[i].getFileName().equalsIgnoreCase("ao.csv")) {
                aoFile = fileList[i];
            }
            if (fileList[i].getFileName().equalsIgnoreCase("do.csv")) {
                doFile = fileList[i];
            }
            if (fileList[i].getFileName().equalsIgnoreCase("vi.csv")) {
                viFile = fileList[i];
            }
            if (!fileList[i].getFileName().equalsIgnoreCase("output.csv")) continue;
            outputFile = fileList[i];
        }
        HashMap toOmit = this.createOmitMap(omitFile);
        this.processNetworkFile(networkFile, network);
        this.processNodeFile(nodeFile, network, toOmit);
        this.processAiFile(aiFile, network, toOmit);
        this.processAoFile(aoFile, network, toOmit);
        this.processDoFile(doFile, network, toOmit);
        this.processViFile(viFile, network, toOmit);
        this.processOutputFile(outputFile, network, toOmit);
        return null;
    }

    public HashMap createOmitMap(BIFile omitFile) {
        HashMap<String, Object> toOmit = new HashMap<String, Object>();
        if (omitFile != null) {
            try {
                InputStream is = omitFile.getInputStream();
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                String inline = "";
                while ((inline = r.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(inline, ",");
                    while (st.hasMoreTokens()) {
                        String noquotes = this.prepItemName(st.nextToken());
                        toOmit.put(noquotes, new Object());
                    }
                }
                Log.getLog((String)"solidyne").trace("" + toOmit.size() + " items in Omit List.");
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return toOmit;
    }

    public boolean includeItem(String itemName, HashMap toOmit) {
        boolean toReturn = !itemName.equals("") && !itemName.equalsIgnoreCase("new_device") && toOmit.get(itemName) == null;
        Log.getLog((String)"solidyne").trace("Checking " + itemName + " " + toOmit.get(itemName) + " " + toOmit.size());
        return toReturn;
    }

    public String prepItemName(String itemName) {
        return itemName.replace('\"', ' ').trim().replace(' ', '_');
    }

    public void processNetworkFile(BIFile networkFile, BSolidyneNetwork network) {
        if (networkFile != null) {
            try {
                InputStream is = networkFile.getInputStream();
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                String inline = "";
                int lineNumber = 0;
                while ((inline = r.readLine()) != null) {
                    StringTokenizer st;
                    if (++lineNumber != 3 || !(st = new StringTokenizer(inline, ",")).hasMoreTokens()) continue;
                    String noquotes = this.prepItemName(st.nextToken());
                    BComponent driversNode = network.getParent().asComponent();
                    driversNode.rename(network.getPropertyInParent(), SlotPath.escape((String)noquotes));
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public void processNodeFile(BIFile nodeFile, BSolidyneNetwork network, HashMap toOmit) {
        if (nodeFile != null) {
            try {
                InputStream is = nodeFile.getInputStream();
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                String inline = "";
                int lineNumber = 0;
                while ((inline = r.readLine()) != null) {
                    BSolidyneAbstractDevice newDev;
                    StringTokenizer st;
                    if (++lineNumber <= 2 || (st = new StringTokenizer(inline, ",")).countTokens() < 2) continue;
                    String noquotes = st.nextToken().replace('\"', ' ').trim();
                    int nodeNum = Integer.parseInt(noquotes);
                    noquotes = this.prepItemName(st.nextToken());
                    st.nextToken();
                    String s = st.nextToken().replace('\"', ' ').trim();
                    int nodeType = Integer.parseInt(s);
                    if (!this.includeItem(noquotes, toOmit)) continue;
                    if (nodeType >= 24) {
                        newDev = new BSolidyneDevice(nodeNum);
                        network.add(SlotPath.escape((String)noquotes) + "?", (BValue)newDev);
                        continue;
                    }
                    newDev = new BSolidyneIzacDevice(nodeNum);
                    network.add(SlotPath.escape((String)noquotes) + "?", (BValue)newDev);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public void processAiFile(BIFile aiFile, BSolidyneNetwork network, HashMap toOmit) {
        if (aiFile != null) {
            try {
                InputStream is = aiFile.getInputStream();
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                String inline = "";
                int lineNumber = 0;
                while ((inline = r.readLine()) != null) {
                    int i;
                    BDeviceExt[] exts;
                    BNumericPoint newPt;
                    StringTokenizer st;
                    if (++lineNumber <= 2 || (st = new StringTokenizer(inline, ",")).countTokens() < 3) continue;
                    String noquotes = st.nextToken().replace('\"', ' ').trim();
                    int nodeNum = Integer.parseInt(noquotes);
                    noquotes = st.nextToken().replace('\"', ' ').trim();
                    int deviceNum = Integer.parseInt(noquotes);
                    noquotes = this.prepItemName(st.nextToken());
                    if (!this.includeItem(noquotes, toOmit)) continue;
                    BSolidyneAbstractDevice targetDev = network.getDeviceByAddress(nodeNum);
                    if (targetDev instanceof BSolidyneDevice) {
                        newPt = new BSolidyneUniversalInputPoint(deviceNum);
                        exts = targetDev.getDeviceExts();
                        for (i = 0; i < exts.length; ++i) {
                            if (!(exts[i] instanceof BSolidynePointDeviceExt)) continue;
                            exts[i].add(SlotPath.escape((String)noquotes) + "?", (BValue)newPt);
                        }
                    }
                    if (!(targetDev instanceof BSolidyneIzacDevice)) continue;
                    newPt = new BSolidyneIzacUniversalInputPoint(deviceNum);
                    exts = targetDev.getDeviceExts();
                    for (i = 0; i < exts.length; ++i) {
                        if (!(exts[i] instanceof BSolidyneIzacPointDeviceExt)) continue;
                        exts[i].add(SlotPath.escape((String)noquotes) + "?", (BValue)newPt);
                    }
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public void processAoFile(BIFile aoFile, BSolidyneNetwork network, HashMap toOmit) {
        if (aoFile != null) {
            try {
                InputStream is = aoFile.getInputStream();
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                String inline = "";
                int lineNumber = 0;
                while ((inline = r.readLine()) != null) {
                    int i;
                    BDeviceExt[] exts;
                    BNumericWritable newPt;
                    StringTokenizer st;
                    if (++lineNumber <= 2 || (st = new StringTokenizer(inline, ",")).countTokens() < 3) continue;
                    String noquotes = st.nextToken().replace('\"', ' ').trim();
                    int nodeNum = Integer.parseInt(noquotes);
                    noquotes = st.nextToken().replace('\"', ' ').trim();
                    int deviceNum = Integer.parseInt(noquotes);
                    noquotes = this.prepItemName(st.nextToken());
                    Log.getLog((String)"solidyne").trace("Checking " + noquotes);
                    Log.getLog((String)"solidyne").trace("Checked: " + this.includeItem(noquotes, toOmit));
                    if (!this.includeItem(noquotes, toOmit)) continue;
                    BSolidyneAbstractDevice targetDev = network.getDeviceByAddress(nodeNum);
                    if (targetDev instanceof BSolidyneDevice) {
                        newPt = new BSolidyneAnalogOutputPoint(deviceNum);
                        exts = targetDev.getDeviceExts();
                        for (i = 0; i < exts.length; ++i) {
                            if (!(exts[i] instanceof BSolidynePointDeviceExt)) continue;
                            exts[i].add(SlotPath.escape((String)noquotes) + "?", (BValue)newPt);
                        }
                    }
                    if (!(targetDev instanceof BSolidyneIzacDevice)) continue;
                    newPt = new BSolidyneIzacAnalogOutputPoint(deviceNum);
                    exts = targetDev.getDeviceExts();
                    for (i = 0; i < exts.length; ++i) {
                        if (!(exts[i] instanceof BSolidyneIzacPointDeviceExt)) continue;
                        exts[i].add(SlotPath.escape((String)noquotes) + "?", (BValue)newPt);
                    }
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public void processDoFile(BIFile doFile, BSolidyneNetwork network, HashMap toOmit) {
        if (doFile != null) {
            try {
                InputStream is = doFile.getInputStream();
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                String inline = "";
                int lineNumber = 0;
                while ((inline = r.readLine()) != null) {
                    int i;
                    BDeviceExt[] exts;
                    BBooleanWritable newPt;
                    StringTokenizer st;
                    if (++lineNumber <= 2 || (st = new StringTokenizer(inline, ",")).countTokens() < 3) continue;
                    String noquotes = st.nextToken().replace('\"', ' ').trim();
                    int nodeNum = Integer.parseInt(noquotes);
                    noquotes = st.nextToken().replace('\"', ' ').trim();
                    int deviceNum = Integer.parseInt(noquotes);
                    noquotes = this.prepItemName(st.nextToken());
                    if (!this.includeItem(noquotes, toOmit)) continue;
                    BSolidyneAbstractDevice targetDev = network.getDeviceByAddress(nodeNum);
                    if (targetDev instanceof BSolidyneDevice) {
                        newPt = new BSolidyneDigitalOutputPoint(deviceNum);
                        exts = targetDev.getDeviceExts();
                        for (i = 0; i < exts.length; ++i) {
                            if (!(exts[i] instanceof BSolidynePointDeviceExt)) continue;
                            exts[i].add(SlotPath.escape((String)noquotes) + "?", (BValue)newPt);
                        }
                    }
                    if (!(targetDev instanceof BSolidyneIzacDevice)) continue;
                    newPt = new BSolidyneIzacDigitalOutputPoint(deviceNum);
                    exts = targetDev.getDeviceExts();
                    for (i = 0; i < exts.length; ++i) {
                        if (!(exts[i] instanceof BSolidyneIzacPointDeviceExt)) continue;
                        exts[i].add(SlotPath.escape((String)noquotes) + "?", (BValue)newPt);
                    }
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public void processViFile(BIFile viFile, BSolidyneNetwork network, HashMap toOmit) {
        if (viFile != null) {
            try {
                InputStream is = viFile.getInputStream();
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                String inline = "";
                int lineNumber = 0;
                while ((inline = r.readLine()) != null) {
                    int i;
                    BDeviceExt[] exts;
                    BNumericWritable newPt;
                    StringTokenizer st;
                    if (++lineNumber <= 2 || (st = new StringTokenizer(inline, ",")).countTokens() < 3) continue;
                    String noquotes = st.nextToken().replace('\"', ' ').trim();
                    int nodeNum = Integer.parseInt(noquotes);
                    noquotes = st.nextToken().replace('\"', ' ').trim();
                    int deviceNum = Integer.parseInt(noquotes);
                    noquotes = this.prepItemName(st.nextToken());
                    if (!this.includeItem(noquotes, toOmit)) continue;
                    BSolidyneAbstractDevice targetDev = network.getDeviceByAddress(nodeNum);
                    if (targetDev instanceof BSolidyneDevice) {
                        newPt = new BSolidyneVirtualPoint(deviceNum);
                        exts = targetDev.getDeviceExts();
                        for (i = 0; i < exts.length; ++i) {
                            if (!(exts[i] instanceof BSolidynePointDeviceExt)) continue;
                            exts[i].add(SlotPath.escape((String)noquotes) + "?", (BValue)newPt);
                        }
                    }
                    if (!(targetDev instanceof BSolidyneIzacDevice)) continue;
                    newPt = new BSolidyneIzacVirtualPoint(deviceNum);
                    exts = targetDev.getDeviceExts();
                    for (i = 0; i < exts.length; ++i) {
                        if (!(exts[i] instanceof BSolidyneIzacPointDeviceExt)) continue;
                        exts[i].add(SlotPath.escape((String)noquotes) + "?", (BValue)newPt);
                    }
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public void processOutputFile(BIFile outputFile, BSolidyneNetwork network, HashMap toOmit) {
        if (outputFile != null) {
            try {
                InputStream is = outputFile.getInputStream();
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                String inline = "";
                int lineNumber = 0;
                while ((inline = r.readLine()) != null) {
                    int i;
                    BDeviceExt[] exts;
                    BISolidynePoint newPt;
                    BSolidyneAbstractDevice targetDev;
                    StringTokenizer st;
                    if (++lineNumber <= 2 || (st = new StringTokenizer(inline, ",")).countTokens() < 3) continue;
                    String noquotes = st.nextToken().replace('\"', ' ').trim();
                    int nodeNum = Integer.parseInt(noquotes);
                    noquotes = st.nextToken().replace('\"', ' ').trim();
                    int deviceNum = Integer.parseInt(noquotes);
                    noquotes = this.prepItemName(st.nextToken());
                    String s = st.nextToken().replace('\"', ' ').trim();
                    int outputType = Integer.parseInt(s);
                    if (!this.includeItem(noquotes, toOmit) || !((targetDev = network.getDeviceByAddress(nodeNum)) instanceof BSolidyneIzacDevice)) continue;
                    if (outputType == 0) {
                        newPt = new BSolidyneIzacDigitalOutputPoint(deviceNum);
                        exts = targetDev.getDeviceExts();
                        for (i = 0; i < exts.length; ++i) {
                            if (!(exts[i] instanceof BSolidyneIzacPointDeviceExt)) continue;
                            exts[i].add(SlotPath.escape((String)noquotes) + "?", (BValue)newPt);
                        }
                    }
                    if (outputType != 1) continue;
                    newPt = new BSolidyneIzacAnalogOutputPoint(deviceNum);
                    exts = targetDev.getDeviceExts();
                    for (i = 0; i < exts.length; ++i) {
                        if (!(exts[i] instanceof BSolidyneIzacPointDeviceExt)) continue;
                        exts[i].add(SlotPath.escape((String)noquotes) + "?", (BValue)newPt);
                    }
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }
}

