/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.ui;

import com.solidyne.solidyne.identify.BSolidynePointId;
import com.solidyne.solidyne.point.BSolidyneAnalogOutputPoint;
import com.solidyne.solidyne.point.BSolidyneDigitalOutputPoint;
import com.solidyne.solidyne.point.BSolidyneProxyExt;
import com.solidyne.solidyne.point.BSolidyneUniversalInputPoint;
import com.solidyne.solidyne.point.BSolidyneVirtualPoint;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BSolidynePointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BSolidynePointManager.class);
    static final Lexicon superLexicon = Lexicon.make(MgrController.class);
    static final UiLexicon lexicon = new UiLexicon(BSolidynePointManager.class);
    static Lexicon driverLex = Lexicon.make((String)"driver");
    static String lexOut = driverLex.getText("out");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colAddress = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSolidyneProxyExt.pointId, BSolidynePointId.portNumber}, 1);
    MgrColumn colValue = new MgrColumn.ToString(lexOut, 0);
    MgrColumn[] SolidyneCols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colAddress, this.colValue};
    public static final MgrTypeInfo UNIVERSAL_INPUT = MgrTypeInfo.make((BComponent)new BSolidyneUniversalInputPoint());
    public static final MgrTypeInfo VIRTUAL_POINT = MgrTypeInfo.make((BComponent)new BSolidyneVirtualPoint());
    public static final MgrTypeInfo DIGITAL_OUTPUT_POINT = MgrTypeInfo.make((BComponent)new BSolidyneDigitalOutputPoint());
    public static final MgrTypeInfo ANALOG_OUTPUT_POINT = MgrTypeInfo.make((BComponent)new BSolidyneAnalogOutputPoint());

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new SolidynePointModel(this);
    }

    protected MgrController makeController() {
        return new SolidynePointController(this);
    }

    public class SolidynePointController
    extends PointController {
        public SolidynePointController(BPointManager manager) {
            super(manager);
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            MgrTypeInfo[] types = this.getManager().getModel().getNewTypes();
            if (types == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown typeField = new BListDropDown();
            for (int i = 0; i < types.length; ++i) {
                typeField.getList().addItem((Object)types[i]);
            }
            typeField.setSelectedIndex(0);
            BTextField countField = new BTextField("1", 6);
            BTextField registerField = new BTextField("1", 6);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.type")));
            grid.add(null, (BValue)typeField);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.count")));
            grid.add(null, (BValue)countField);
            grid.add(null, (BValue)new BLabel("Start Address"));
            grid.add(null, (BValue)registerField);
            String title = this.newCommand.getLabel();
            MgrTypeInfo type = null;
            int count = 0;
            int startAddress = 0;
            boolean done = false;
            while (!done) {
                int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
                if (r == 2) {
                    return null;
                }
                type = (MgrTypeInfo)typeField.getSelectedItem();
                count = Integer.parseInt(countField.getText());
                startAddress = Integer.parseInt(registerField.getText());
                if (!this.validAddress(type, startAddress)) {
                    BDialog.error((BWidget)this.getManager(), (Object)("Invalid port address (" + startAddress + ") for point type (" + type.toString() + ")"));
                    continue;
                }
                done = true;
            }
            MgrEdit edit = this.makeEdit(title);
            for (int i = 0; i < count; ++i) {
                BComponent comp = ((SolidynePointModel)this.getManager().getModel()).newInstance(type, startAddress + i);
                MgrEditRow row = new MgrEditRow(comp, null, types);
                if (!this.validAddress(type, startAddress + i)) {
                    BDialog.error((BWidget)this.getManager(), (Object)("Invalid port address (" + (startAddress + i) + ") for point type (" + type.toString() + ")"));
                    continue;
                }
                edit.addRow(row);
                row.setDefaultName(SlotPath.escape((String)(type.getDisplayName() + (startAddress + i))));
            }
            return edit;
        }

        private boolean validAddress(MgrTypeInfo type, int address) {
            if (type.equals((Object)UNIVERSAL_INPUT)) {
                return address >= 1 && address <= 8;
            }
            if (type.equals((Object)VIRTUAL_POINT)) {
                return address >= 1 && address <= 16;
            }
            if (type.equals((Object)DIGITAL_OUTPUT_POINT)) {
                return address >= 1 && address <= 8;
            }
            if (type.equals((Object)ANALOG_OUTPUT_POINT)) {
                return address >= 1 && address <= 8;
            }
            return false;
        }
    }

    public class SolidynePointModel
    extends PointModel {
        SolidynePointModel(BSolidynePointManager mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BSolidynePointManager.this.SolidyneCols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList<MgrTypeInfo> list = new ArrayList<MgrTypeInfo>();
            list.add(UNIVERSAL_INPUT);
            list.add(VIRTUAL_POINT);
            list.add(DIGITAL_OUTPUT_POINT);
            list.add(ANALOG_OUTPUT_POINT);
            return list.toArray(new MgrTypeInfo[list.size()]);
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            return this.newInstance(type, 1);
        }

        public BComponent newInstance(MgrTypeInfo type, int register) throws Exception {
            BControlPoint pt = null;
            BSolidyneProxyExt ext = new BSolidyneProxyExt();
            pt = (BControlPoint)type.newInstance();
            ((BSolidynePointId)ext.getPointId()).setPortNumber(register);
            Property portNum = ((BSolidynePointId)ext.getPointId()).getProperty("portNumber");
            if (type.equals((Object)VIRTUAL_POINT)) {
                ((BSolidynePointId)ext.getPointId()).setFacets((Slot)portNum, BFacets.make((String[])new String[]{"min", "max"}, (BIDataValue[])new BInteger[]{BInteger.make((int)1), BInteger.make((int)16)}));
            } else {
                ((BSolidynePointId)ext.getPointId()).setFacets((Slot)portNum, BFacets.make((String[])new String[]{"min", "max"}, (BIDataValue[])new BInteger[]{BInteger.make((int)1), BInteger.make((int)8)}));
            }
            BFacets deviceFacets = (BFacets)pt.getFacets().newCopy();
            ext.setDeviceFacets(deviceFacets);
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }
    }
}

