/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne;

import com.solidyne.solidyne.BSolidyneAbstractDevice;
import com.solidyne.solidyne.BSolidyneDeviceFolder;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.discover.BSolidyneDeviceDiscoveryPreferences;
import com.solidyne.solidyne.identify.BSolidyneDeviceId;
import com.tridium.ddf.discover.BDdfDiscoveryPreferences;
import com.tridium.ddfSerial.BDdfSerialNetwork;
import java.util.Date;
import javax.baja.driver.BDevice;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSolidyneNetwork
extends BDdfSerialNetwork {
    public static final Property code = BSolidyneNetwork.newProperty((int)0, (String)"", null);
    public static final Property licenseStatus = BSolidyneNetwork.newProperty((int)0, (String)"", null);
    public static final Property communicator = BSolidyneNetwork.newProperty((int)0, (BValue)new BSolidyneCommunicator(), null);
    public static final Property discoveryPreferences = BSolidyneNetwork.newProperty((int)0, (BValue)new BSolidyneDeviceDiscoveryPreferences(), null);
    public static final Property comPortForcedClosed = BSolidyneNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property hostId = BSolidyneNetwork.newProperty((int)1, (String)"", null);
    public static final Action forceComPortClosed = BSolidyneNetwork.newAction((int)0, null);
    public static final Type TYPE;
    protected static boolean licensed;
    private static long stationStart;
    protected static boolean demoMode;
    static /* synthetic */ Class class$com$solidyne$solidyne$BSolidyneNetwork;

    public String getCode() {
        return this.getString(code);
    }

    public void setCode(String string) {
        this.setString(code, string, null);
    }

    public String getLicenseStatus() {
        return this.getString(licenseStatus);
    }

    public void setLicenseStatus(String string) {
        this.setString(licenseStatus, string, null);
    }

    public BValue getCommunicator() {
        return this.get(communicator);
    }

    public void setCommunicator(BValue bValue) {
        this.set(communicator, bValue, null);
    }

    public BDdfDiscoveryPreferences getDiscoveryPreferences() {
        return (BDdfDiscoveryPreferences)this.get(discoveryPreferences);
    }

    public void setDiscoveryPreferences(BDdfDiscoveryPreferences bDdfDiscoveryPreferences) {
        this.set(discoveryPreferences, (BValue)bDdfDiscoveryPreferences, null);
    }

    public boolean getComPortForcedClosed() {
        return this.getBoolean(comPortForcedClosed);
    }

    public void setComPortForcedClosed(boolean bl) {
        this.setBoolean(comPortForcedClosed, bl, null);
    }

    public String getHostId() {
        return this.getString(hostId);
    }

    public void setHostId(String string) {
        this.setString(hostId, string, null);
    }

    public void forceComPortClosed() {
        this.invoke(forceComPortClosed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        stationStart = new Date().getTime();
        super.started();
        this.setHostId(Sys.getHostId());
        this.checkLicense();
    }

    public void changed(Property property, Context context) {
        block11: {
            if (this.isRunning()) {
                if (property.equals((Object)enabled) || property.equals((Object)code)) {
                    this.checkLicense();
                    if (!licensed && !demoMode) {
                        this.setEnabled(false);
                    }
                }
                if (property.equals((Object)code)) {
                    boolean bl = false;
                    if (licensed || demoMode) {
                        bl = true;
                    }
                    this.setEnabled(bl);
                }
                if (property.equals((Object)comPortForcedClosed)) {
                    if (!this.getEnabled()) {
                        try {
                            BSolidyneCommunicator bSolidyneCommunicator = (BSolidyneCommunicator)this.getCommunicator();
                            if (this.getComPortForcedClosed()) {
                                Log.getLog((String)"solidyne").trace("Handling disable");
                                bSolidyneCommunicator.stopped();
                                break block11;
                            }
                            Log.getLog((String)"solidyne").trace("Handling enable");
                            bSolidyneCommunicator.started();
                        }
                        catch (Exception exception) {
                            Log.getLog((String)"solidyne").error("Error closing comm port.");
                            exception.printStackTrace();
                        }
                    } else {
                        Log.getLog((String)"solidyne").error("Cannot close or open COM port while network is Enabled. Please disable and retry command.");
                        this.setComPortForcedClosed(false);
                    }
                }
            }
        }
        super.changed(property, context);
    }

    public void doForceComPortClosed() {
        try {
            BSolidyneCommunicator bSolidyneCommunicator = (BSolidyneCommunicator)this.getCommunicator();
            if (this.getEnabled()) {
                Log.getLog((String)"solidyne").error("Cannot close COM port while network is Enabled. Please disable and retry command.");
            } else {
                Log.getLog((String)"solidyne").trace("Handling disable");
                bSolidyneCommunicator.stopped();
            }
        }
        catch (Exception exception) {
            Log.getLog((String)"solidyne").error("Error closing comm port.");
            exception.printStackTrace();
        }
    }

    public Type getDeviceType() {
        return BSolidyneAbstractDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BSolidyneDeviceFolder.TYPE;
    }

    public BSolidyneAbstractDevice getDeviceByAddress(int n) {
        BSolidyneAbstractDevice bSolidyneAbstractDevice = null;
        BDevice[] bDeviceArray = this.getDevices();
        int n2 = 0;
        while (n2 < bDeviceArray.length) {
            bSolidyneAbstractDevice = (BSolidyneAbstractDevice)bDeviceArray[n2];
            if (((BSolidyneDeviceId)bSolidyneAbstractDevice.getDeviceId()).getUnitNumber() == n) {
                return bSolidyneAbstractDevice;
            }
            ++n2;
        }
        return null;
    }

    public void flagUnresponsiveDevices(int n) {
        BDevice[] bDeviceArray = this.getDevices();
        int n2 = 0;
        while (n2 < bDeviceArray.length) {
            if (bDeviceArray[n2] instanceof BSolidyneAbstractDevice) {
                ((BSolidyneAbstractDevice)bDeviceArray[n2]).pingFail("Too long since last message.");
            }
            ++n2;
        }
    }

    protected final void checkLicense() {
        String string = Sys.getHostId();
        String string2 = string.substring(string.length() - 9, string.length() - 5) + string.substring(string.length() - 4, string.length());
        String string3 = "";
        int n = 0;
        while (n < string2.length()) {
            String string4 = string2.substring(n, n + 1);
            int n2 = Integer.parseInt(string4, 16);
            string3 = string3 + "DFZCQXUNIBVMGJAT".charAt(n2);
            ++n;
        }
        if (this.getCode().equalsIgnoreCase(string3)) {
            licensed = true;
            demoMode = false;
            this.setLicenseStatus("Licensed.");
        } else {
            licensed = false;
            long l = new Date().getTime();
            if (l - stationStart > 0x6DDD00L) {
                if (demoMode) {
                    Log.getLog((String)"solidyne").message("solidyne driver 120 minute trial mode has expired.");
                }
                demoMode = false;
                licensed = false;
                this.setEnabled(false);
                this.setLicenseStatus("Trial mode has expired.");
            } else {
                if (!demoMode) {
                    Log.getLog((String)"solidyne").message("solidyne driver is not licensed to run on this station");
                    Log.getLog((String)"solidyne").message("solidyne driver trial mode started.");
                }
                demoMode = true;
                licensed = false;
                this.setLicenseStatus("120 minute trial mode is active.");
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$solidyne$solidyne$BSolidyneNetwork;
        if (clazz == null) {
            clazz = class$com$solidyne$solidyne$BSolidyneNetwork = BSolidyneNetwork.class("[Lcom.solidyne.solidyne.BSolidyneNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        licensed = true;
        stationStart = 0L;
        demoMode = false;
    }
}

