/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm.req;

import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.solidyne.solidyne.comm.rsp.SolidyneMessageFactory;
import com.solidyne.solidyne.identify.BSolidyneDeviceId;
import com.solidyne.solidyne.identify.BSolidynePointId;
import com.solidyne.solidyne.identify.BSolidynePortTypeEnum;
import com.solidyne.solidyne.izac.point.BSolidyneIzacProxyExt;
import com.solidyne.solidyne.point.BSolidyneAbstractProxyExt;
import com.solidyne.solidyne.util.Utils;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.point.BDdfProxyExt;
import javax.baja.log.Log;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSolidyneSetRequest
extends BDdfWriteRequest {
    public static final Property portType = BSolidyneSetRequest.newProperty((int)0, (BValue)BSolidynePortTypeEnum.Virtual, null);
    public static final Property portNumber = BSolidyneSetRequest.newProperty((int)0, (int)0, null);
    public static final Type TYPE;
    public static byte ACTION_CANCEL;
    public static byte ACTION_TRIGGER;
    public static byte ACTION_QUERY;
    protected int targetDevice;
    protected byte targetPoint_h;
    protected byte targetPoint_l;
    protected byte newVal_h;
    protected byte newVal_l;
    protected double newVal;
    protected BDdfProxyExt myProxy;
    protected boolean thisRequestWasCreatedExplicitly;
    IDdfWritable[] writableSource;
    BDdfIdParams requestId;
    static /* synthetic */ Class class$com$solidyne$solidyne$comm$req$BSolidyneSetRequest;

    public BSolidynePortTypeEnum getPortType() {
        return (BSolidynePortTypeEnum)this.get(portType);
    }

    public void setPortType(BSolidynePortTypeEnum bSolidynePortTypeEnum) {
        this.set(portType, (BValue)bSolidynePortTypeEnum, null);
    }

    public int getPortNumber() {
        return this.getInt(portNumber);
    }

    public void setPortNumber(int n) {
        this.setInt(portNumber, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getTargetAddress() {
        BSolidynePointId bSolidynePointId = (BSolidynePointId)this.myProxy.getPointId();
        String string = Integer.toString(bSolidynePointId.getPortNumber());
        return string;
    }

    public void setAllAddresses() {
        this.targetDevice = ((BSolidyneDeviceId)this.getDeviceId()).getUnitNumber();
        this.newVal = this.getRawValue((IDdfWritable)this.myProxy);
        BSolidynePointId bSolidynePointId = (BSolidynePointId)this.myProxy.getPointId();
        BStatusValue bStatusValue = this.myProxy.getWriteValue();
        byte[] byArray = new byte[2];
        Log.getLog((String)"solidyne").trace("setAllAddresses - pointType = " + (Object)((Object)bSolidynePointId.getPointType()));
        BSolidynePortTypeEnum bSolidynePortTypeEnum = bSolidynePointId.getPointType();
        if (bSolidynePortTypeEnum.equals((Object)BSolidynePortTypeEnum.UniversalInput) || bSolidynePortTypeEnum.equals((Object)BSolidynePortTypeEnum.IzacUniversalInput)) {
            byArray = Utils.makeAddress(this.targetDevice, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_UI_AVG);
        }
        if (bSolidynePortTypeEnum.equals((Object)BSolidynePortTypeEnum.Virtual) || bSolidynePortTypeEnum.equals((Object)BSolidynePortTypeEnum.IzacVirtual)) {
            byArray = bSolidynePointId.getPortNumber() <= 8 ? Utils.makeAddress(this.targetDevice, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_VIRTUAL) : Utils.makeAddress(this.targetDevice, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_EXT_VIRTUAL);
        }
        if (bSolidynePortTypeEnum.equals((Object)BSolidynePortTypeEnum.AnalogOut) || bSolidynePortTypeEnum.equals((Object)BSolidynePortTypeEnum.IzacAnalogOut)) {
            byArray = Utils.makeAddress(this.targetDevice, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_AO);
        }
        if (bSolidynePortTypeEnum.equals((Object)BSolidynePortTypeEnum.DigitalOut) || bSolidynePortTypeEnum.equals((Object)BSolidynePortTypeEnum.IzacDigitalOut)) {
            byArray = Utils.makeAddress(this.targetDevice, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_DO);
        }
        this.targetPoint_h = byArray[0];
        this.targetPoint_l = byArray[1];
        byte[] byArray2 = Utils.encodeReal(this.newVal);
        this.newVal_h = byArray2[0];
        this.newVal_l = byArray2[1];
    }

    public byte[] toByteArray() {
        byte[] byArray;
        Log.getLog((String)"solidyne_virtualWrite").trace("PACKAGING SET REQUEST for " + this.myProxy.getDdfDevice().getNavName() + " to " + this.myProxy.getPointId().toString());
        if (!this.thisRequestWasCreatedExplicitly) {
            this.setAllAddresses();
        }
        BSolidyneNetwork bSolidyneNetwork = (BSolidyneNetwork)this.myProxy.getNetwork();
        int n = ((BSolidyneCommunicator)bSolidyneNetwork.getCommunicator()).getHostDeviceAddress();
        int n2 = 0;
        if (this.targetDevice < 256) {
            byte[] byArray2 = new byte[11];
            byArray2[0] = 127;
            byArray2[3] = 101;
            byArray2[5] = 4;
            byArray = byArray2;
            byArray[1] = (byte)n;
            byArray[2] = (byte)this.targetDevice;
        } else {
            byte[] byArray3 = new byte[16];
            byArray3[0] = 127;
            byArray3[3] = 101;
            byArray3[5] = 9;
            byArray = byArray3;
            byArray[7] = 0;
            byArray[8] = (byte)n;
            byArray[9] = (byte)(this.targetDevice >> 8 & 0xFF);
            byArray[10] = (byte)(this.targetDevice & 0xFF);
            n2 = 5;
        }
        byArray[6 + n2] = this.targetPoint_h;
        byArray[7 + n2] = this.targetPoint_l;
        byArray[8 + n2] = this.newVal_h;
        byArray[9 + n2] = this.newVal_l;
        byte by = 0;
        int n3 = 0;
        while (n3 < byArray.length - 1) {
            by = (byte)(by + byArray[n3]);
            ++n3;
        }
        byArray[byArray.length - 1] = by;
        return Utils.escapeMessage(byArray);
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        try {
            BSolidyneResponse bSolidyneResponse = SolidyneMessageFactory.makeMessage(iDdfDataFrame);
            if (bSolidyneResponse.msgType == 229) {
                Log.getLog((String)"solidyne_virtualWrite").trace("RECEIVED SET REQUEST RESPONSE!!!  for " + this.myProxy.getDdfDevice().getNavName() + " to " + this.myProxy.getPointId().toString());
                this.myProxy.writeOk(this.myProxy.getWriteValue());
                return bSolidyneResponse;
            }
        }
        catch (Exception exception) {
            throw new DdfResponseException();
        }
        return null;
    }

    public boolean isGroupable() {
        return false;
    }

    public BDdfIdParams getWriteParameters() {
        return this.requestId;
    }

    public void setWriteParameters(BDdfIdParams bDdfIdParams) {
        this.requestId = bDdfIdParams;
    }

    public IDdfWritable[] getWritableSource() {
        return this.writableSource;
    }

    public void setWritableSource(IDdfWritable[] iDdfWritableArray) {
        this.writableSource = iDdfWritableArray;
        if (iDdfWritableArray.length > 0 && iDdfWritableArray[0] instanceof BSolidyneAbstractProxyExt) {
            this.myProxy = (BSolidyneAbstractProxyExt)iDdfWritableArray[0];
        }
    }

    public boolean getAutoWriteOk() {
        return true;
    }

    public boolean getAutoWriteOkLate() {
        return false;
    }

    public boolean getAutoWriteFailOnTimeout() {
        return false;
    }

    public boolean getAutoWriteFailOnError() {
        return false;
    }

    public void setDeviceId(BDdfIdParams bDdfIdParams) {
        super.setDeviceId(bDdfIdParams);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.thisRequestWasCreatedExplicitly = false;
    }

    public BSolidyneSetRequest() {
        this.this();
        Log.getLog((String)"solidyne_virtualWrite").trace("Making non-explicit set request");
    }

    public BSolidyneSetRequest(BSolidyneAbstractProxyExt bSolidyneAbstractProxyExt, int n, double d) {
        this.this();
        Log.getLog((String)"solidyne_virtualWrite").trace("Making normal set request");
        this.targetDevice = n;
        byte[] byArray = new byte[2];
        BSolidynePointId bSolidynePointId = (BSolidynePointId)bSolidyneAbstractProxyExt.getPointId();
        if (bSolidyneAbstractProxyExt.getPortType().equals((Object)BSolidynePortTypeEnum.UniversalInput)) {
            byArray = Utils.makeAddress(n, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_UI_AVG);
        }
        if (bSolidyneAbstractProxyExt.getPortType().equals((Object)BSolidynePortTypeEnum.Virtual)) {
            byArray = bSolidynePointId.getPortNumber() <= 8 ? Utils.makeAddress(n, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_VIRTUAL) : Utils.makeAddress(n, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_EXT_VIRTUAL);
        }
        if (bSolidyneAbstractProxyExt.getPortType().equals((Object)BSolidynePortTypeEnum.AnalogOut)) {
            byArray = Utils.makeAddress(n, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_AO);
        }
        if (bSolidyneAbstractProxyExt.getPortType().equals((Object)BSolidynePortTypeEnum.DigitalOut)) {
            byArray = Utils.makeAddress(n, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_DO);
        }
        this.myProxy = bSolidyneAbstractProxyExt;
        this.targetPoint_h = byArray[0];
        this.targetPoint_l = byArray[1];
        byte[] byArray2 = Utils.encodeReal(d);
        this.newVal_h = byArray2[0];
        this.newVal_l = byArray2[1];
        this.thisRequestWasCreatedExplicitly = true;
    }

    public BSolidyneSetRequest(BSolidyneIzacProxyExt bSolidyneIzacProxyExt, int n, double d) {
        this.this();
        Log.getLog((String)"solidyne_virtualWrite").trace("Making izac set request");
        this.targetDevice = n;
        byte[] byArray = new byte[2];
        BSolidynePointId bSolidynePointId = (BSolidynePointId)bSolidyneIzacProxyExt.getPointId();
        if (bSolidyneIzacProxyExt.getPortType().equals((Object)BSolidynePortTypeEnum.IzacUniversalInput)) {
            byArray = Utils.makeAddress(n, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_UI_AVG);
        }
        if (bSolidyneIzacProxyExt.getPortType().equals((Object)BSolidynePortTypeEnum.IzacVirtual)) {
            byArray = Utils.makeAddress(n, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_VIRTUAL);
        }
        if (bSolidyneIzacProxyExt.getPortType().equals((Object)BSolidynePortTypeEnum.IzacAnalogOut)) {
            byArray = Utils.makeAddress(n, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_AO);
        }
        if (bSolidyneIzacProxyExt.getPortType().equals((Object)BSolidynePortTypeEnum.IzacDigitalOut)) {
            byArray = Utils.makeAddress(n, bSolidynePointId.getPortNumber(), Utils.POINTTYPE_DO);
        }
        this.myProxy = bSolidyneIzacProxyExt;
        this.targetPoint_h = byArray[0];
        this.targetPoint_l = byArray[1];
        byte[] byArray2 = Utils.encodeReal(d);
        this.newVal_h = byArray2[0];
        this.newVal_l = byArray2[1];
        this.thisRequestWasCreatedExplicitly = true;
    }

    static {
        Class clazz = class$com$solidyne$solidyne$comm$req$BSolidyneSetRequest;
        if (clazz == null) {
            clazz = class$com$solidyne$solidyne$comm$req$BSolidyneSetRequest = BSolidyneSetRequest.class("[Lcom.solidyne.solidyne.comm.req.BSolidyneSetRequest;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ACTION_CANCEL = 0;
        ACTION_TRIGGER = 1;
        ACTION_QUERY = (byte)-1;
    }
}

