/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.izac;

import com.solidyne.solidyne.BSolidyneAbstractDevice;
import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.comm.rsp.BSolidyneGetForcedResponse;
import com.solidyne.solidyne.comm.rsp.BSolidynePublishedExtendedVirtualSensorValuesMessage;
import com.solidyne.solidyne.comm.rsp.BSolidynePublishedSensorValuesMessage;
import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.solidyne.solidyne.identify.BSolidyneDeviceId;
import com.solidyne.solidyne.izac.BSolidyneIzacAnalogOutput;
import com.solidyne.solidyne.izac.BSolidyneIzacAnalogOutputs;
import com.solidyne.solidyne.izac.BSolidyneIzacDigitalOutput;
import com.solidyne.solidyne.izac.BSolidyneIzacDigitalOutputs;
import com.solidyne.solidyne.izac.BSolidyneIzacPointDeviceExt;
import com.solidyne.solidyne.izac.BSolidyneIzacSensorInput;
import com.solidyne.solidyne.izac.BSolidyneIzacSensorInputs;
import com.solidyne.solidyne.izac.BSolidyneIzacVirtual;
import com.solidyne.solidyne.izac.BSolidyneIzacVirtuals;
import com.solidyne.solidyne.izac.point.BSolidyneIzacProxyExt;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSolidyneIzacDevice
extends BSolidyneAbstractDevice {
    public static final Property points = BSolidyneIzacDevice.newProperty((int)0, (BValue)new BSolidyneIzacPointDeviceExt(), null);
    public static final Property sensorInputs = BSolidyneIzacDevice.newProperty((int)0, (BValue)new BSolidyneIzacSensorInputs(), null);
    public static final Property virtualPoints = BSolidyneIzacDevice.newProperty((int)0, (BValue)new BSolidyneIzacVirtuals(), null);
    public static final Property analogOutputs = BSolidyneIzacDevice.newProperty((int)0, (BValue)new BSolidyneIzacAnalogOutputs(), null);
    public static final Property digitalOutputs = BSolidyneIzacDevice.newProperty((int)0, (BValue)new BSolidyneIzacDigitalOutputs(), null);
    public static final Type TYPE;
    Vector subscribedPoints;
    static /* synthetic */ Class class$com$solidyne$solidyne$izac$BSolidyneIzacDevice;

    public BSolidyneIzacPointDeviceExt getPoints() {
        return (BSolidyneIzacPointDeviceExt)this.get(points);
    }

    public void setPoints(BSolidyneIzacPointDeviceExt bSolidyneIzacPointDeviceExt) {
        this.set(points, (BValue)bSolidyneIzacPointDeviceExt, null);
    }

    public BSolidyneIzacSensorInputs getSensorInputs() {
        return (BSolidyneIzacSensorInputs)this.get(sensorInputs);
    }

    public void setSensorInputs(BSolidyneIzacSensorInputs bSolidyneIzacSensorInputs) {
        this.set(sensorInputs, (BValue)bSolidyneIzacSensorInputs, null);
    }

    public BSolidyneIzacVirtuals getVirtualPoints() {
        return (BSolidyneIzacVirtuals)this.get(virtualPoints);
    }

    public void setVirtualPoints(BSolidyneIzacVirtuals bSolidyneIzacVirtuals) {
        this.set(virtualPoints, (BValue)bSolidyneIzacVirtuals, null);
    }

    public BSolidyneIzacAnalogOutputs getAnalogOutputs() {
        return (BSolidyneIzacAnalogOutputs)this.get(analogOutputs);
    }

    public void setAnalogOutputs(BSolidyneIzacAnalogOutputs bSolidyneIzacAnalogOutputs) {
        this.set(analogOutputs, (BValue)bSolidyneIzacAnalogOutputs, null);
    }

    public BSolidyneIzacDigitalOutputs getDigitalOutputs() {
        return (BSolidyneIzacDigitalOutputs)this.get(digitalOutputs);
    }

    public void setDigitalOutputs(BSolidyneIzacDigitalOutputs bSolidyneIzacDigitalOutputs) {
        this.set(digitalOutputs, (BValue)bSolidyneIzacDigitalOutputs, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doPing() {
        BSolidyneNetwork bSolidyneNetwork = (BSolidyneNetwork)this.getNetwork();
        BSolidyneCommunicator bSolidyneCommunicator = (BSolidyneCommunicator)bSolidyneNetwork.getCommunicator();
        int n = bSolidyneCommunicator.getInactivityTimeout();
        BAbsTime bAbsTime = this.getHealth().getLastOkTime();
        BAbsTime bAbsTime2 = BAbsTime.make();
        long l = bAbsTime2.getMillis() - bAbsTime.getMillis();
        if (l > (long)n) {
            this.pingFail("Too long since last message.");
        } else {
            this.pingOk();
        }
    }

    public void started() throws Exception {
        BSolidyneNetwork bSolidyneNetwork = (BSolidyneNetwork)this.getNetwork();
        BSolidyneCommunicator bSolidyneCommunicator = (BSolidyneCommunicator)bSolidyneNetwork.getCommunicator();
        int n = bSolidyneCommunicator.getHostDeviceAddress();
        ((BSolidyneDeviceId)this.getDeviceId()).setHostDeviceAddress(n);
    }

    public Type getNetworkType() {
        return BSolidyneNetwork.TYPE;
    }

    public void handleMessage(BSolidyneResponse bSolidyneResponse) {
        Log.getLog((String)"solidyne").trace("Device handling messge. Type=" + bSolidyneResponse.msgType);
        this.pingOk();
        Log.getLog((String)"solidyne").trace("SolidyneIzacDevice: handleMessage " + bSolidyneResponse.msgType);
        switch (bSolidyneResponse.msgType) {
            case 71: {
                this.processPublishedSensorValuesMsg((BSolidynePublishedSensorValuesMessage)bSolidyneResponse);
                break;
            }
            case 111: {
                this.processPublishedExtendedVirtualSensorValuesMsg((BSolidynePublishedExtendedVirtualSensorValuesMessage)bSolidyneResponse);
                break;
            }
            case 156: {
                this.processGetForcedStatesAndValuesMsg((BSolidyneGetForcedResponse)bSolidyneResponse);
            }
        }
        this.updateProxies();
    }

    public void processGetForcedStatesAndValuesMsg(BSolidyneGetForcedResponse bSolidyneGetForcedResponse) {
    }

    public void processPublishedSensorValuesMsg(BSolidynePublishedSensorValuesMessage bSolidynePublishedSensorValuesMessage) {
        int n = 0;
        while (n < 8) {
            ((BSolidyneIzacSensorInput)this.getSensorInputs().get("s" + (n + 1))).setAverage(new BStatusNumeric((double)bSolidynePublishedSensorValuesMessage.avgInput[n]));
            ((BSolidyneIzacSensorInput)this.getSensorInputs().get("s" + (n + 1))).setInstantaneous(new BStatusNumeric((double)bSolidynePublishedSensorValuesMessage.instInput[n]));
            ((BSolidyneIzacSensorInput)this.getSensorInputs().get("s" + (n + 1))).setOverridden(bSolidynePublishedSensorValuesMessage.sensorOverride[n]);
            ++n;
        }
        n = 0;
        while (n < 8) {
            ((BSolidyneIzacVirtual)this.getVirtualPoints().get("v" + (n + 1))).setValue(new BStatusNumeric((double)bSolidynePublishedSensorValuesMessage.virtual[n]));
            ++n;
        }
        n = 0;
        while (n < 8) {
            ((BSolidyneIzacAnalogOutput)this.getAnalogOutputs().get("ao" + (n + 1))).setValue(new BStatusNumeric((double)bSolidynePublishedSensorValuesMessage.analogOutput[n]));
            ++n;
        }
        n = 0;
        while (n < 8) {
            ((BSolidyneIzacDigitalOutput)this.getDigitalOutputs().get("do" + (n + 1))).setValue(new BStatusBoolean(bSolidynePublishedSensorValuesMessage.outputState[n]));
            ((BSolidyneIzacDigitalOutput)this.getDigitalOutputs().get("do" + (n + 1))).setValueOverridden(bSolidynePublishedSensorValuesMessage.outputOverride[n]);
            ++n;
        }
    }

    public void processPublishedExtendedVirtualSensorValuesMsg(BSolidynePublishedExtendedVirtualSensorValuesMessage bSolidynePublishedExtendedVirtualSensorValuesMessage) {
    }

    protected void updateProxies() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        Log.getLog((String)"solidyne").trace("Updating proxies " + this.subscribedPoints.size());
        int n = 0;
        while (n < this.subscribedPoints.size()) {
            BComponent bComponent = bComponentSpace.findByHandle(this.subscribedPoints.get(n));
            if (bComponent instanceof BSolidyneIzacProxyExt) {
                BSolidyneIzacProxyExt bSolidyneIzacProxyExt = (BSolidyneIzacProxyExt)bComponent;
                bSolidyneIzacProxyExt.readOk();
            }
            ++n;
        }
    }

    public void registerProxy(BSolidyneIzacProxyExt bSolidyneIzacProxyExt) {
        Log.getLog((String)"solidyne").trace("Registering proxy");
        this.subscribedPoints.add(bSolidyneIzacProxyExt.getHandle());
        this.updateProxies();
    }

    public void unregisterProxy(BSolidyneIzacProxyExt bSolidyneIzacProxyExt) {
        int n = this.subscribedPoints.size() - 1;
        while (n >= 0) {
            if (bSolidyneIzacProxyExt.getHandle().equals(this.subscribedPoints.get(n))) {
                this.subscribedPoints.remove(n);
            }
            --n;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.subscribedPoints = new Vector();
    }

    public BSolidyneIzacDevice() {
        this.this();
    }

    public BSolidyneIzacDevice(int n) {
        this.this();
        ((BSolidyneDeviceId)this.getDeviceId()).setUnitNumber(n);
    }

    static {
        Class clazz = class$com$solidyne$solidyne$izac$BSolidyneIzacDevice;
        if (clazz == null) {
            clazz = class$com$solidyne$solidyne$izac$BSolidyneIzacDevice = BSolidyneIzacDevice.class("[Lcom.solidyne.solidyne.izac.BSolidyneIzacDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

