/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne;

import com.solidyne.solidyne.BSolidyneAbstractDevice;
import com.solidyne.solidyne.BSolidyneDeviceFolder;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.discover.BSolidyneDeviceDiscoveryPreferences;
import com.solidyne.solidyne.identify.BSolidyneDeviceId;
import com.tridium.ddf.discover.BDdfDiscoveryPreferences;
import com.tridium.ddfSerial.BDdfSerialNetwork;
import java.util.Date;
import javax.baja.driver.BDevice;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidyneNetwork
extends BDdfSerialNetwork {
    public static final Property code = BSolidyneNetwork.newProperty((int)0, (String)"", null);
    public static final Property licenseStatus = BSolidyneNetwork.newProperty((int)0, (String)"", null);
    public static final Property communicator = BSolidyneNetwork.newProperty((int)0, (BValue)new BSolidyneCommunicator(), null);
    public static final Property discoveryPreferences = BSolidyneNetwork.newProperty((int)0, (BValue)new BSolidyneDeviceDiscoveryPreferences(), null);
    public static final Property comPortForcedClosed = BSolidyneNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property hostId = BSolidyneNetwork.newProperty((int)1, (String)"", null);
    public static final Action forceComPortClosed = BSolidyneNetwork.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSolidyneNetwork.class);
    protected static boolean licensed = true;
    private static long stationStart = 0L;
    protected static boolean demoMode = false;

    public String getCode() {
        return this.getString(code);
    }

    public void setCode(String v) {
        this.setString(code, v, null);
    }

    public String getLicenseStatus() {
        return this.getString(licenseStatus);
    }

    public void setLicenseStatus(String v) {
        this.setString(licenseStatus, v, null);
    }

    public BValue getCommunicator() {
        return this.get(communicator);
    }

    public void setCommunicator(BValue v) {
        this.set(communicator, v, null);
    }

    public BDdfDiscoveryPreferences getDiscoveryPreferences() {
        return (BDdfDiscoveryPreferences)this.get(discoveryPreferences);
    }

    public void setDiscoveryPreferences(BDdfDiscoveryPreferences v) {
        this.set(discoveryPreferences, (BValue)v, null);
    }

    public boolean getComPortForcedClosed() {
        return this.getBoolean(comPortForcedClosed);
    }

    public void setComPortForcedClosed(boolean v) {
        this.setBoolean(comPortForcedClosed, v, null);
    }

    public String getHostId() {
        return this.getString(hostId);
    }

    public void setHostId(String v) {
        this.setString(hostId, v, null);
    }

    public void forceComPortClosed() {
        this.invoke(forceComPortClosed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        stationStart = new Date().getTime();
        super.started();
        this.setHostId(Sys.getHostId());
        this.checkLicense();
    }

    public void changed(Property property, Context context) {
        block10: {
            if (this.isRunning()) {
                if (property.equals(enabled) || property.equals(code)) {
                    this.checkLicense();
                    if (!licensed && !demoMode) {
                        this.setEnabled(false);
                    }
                }
                if (property.equals(code)) {
                    this.setEnabled(licensed || demoMode);
                }
                if (property.equals(comPortForcedClosed)) {
                    if (!this.getEnabled()) {
                        try {
                            BSolidyneCommunicator comm = (BSolidyneCommunicator)this.getCommunicator();
                            if (this.getComPortForcedClosed()) {
                                Log.getLog((String)"solidyne").trace("Handling disable");
                                comm.stopped();
                                break block10;
                            }
                            Log.getLog((String)"solidyne").trace("Handling enable");
                            comm.started();
                        }
                        catch (Exception exc) {
                            Log.getLog((String)"solidyne").error("Error closing comm port.");
                            exc.printStackTrace();
                        }
                    } else {
                        Log.getLog((String)"solidyne").error("Cannot close or open COM port while network is Enabled. Please disable and retry command.");
                        this.setComPortForcedClosed(false);
                    }
                }
            }
        }
        super.changed(property, context);
    }

    public void doForceComPortClosed() {
        try {
            BSolidyneCommunicator comm = (BSolidyneCommunicator)this.getCommunicator();
            if (this.getEnabled()) {
                Log.getLog((String)"solidyne").error("Cannot close COM port while network is Enabled. Please disable and retry command.");
            } else {
                Log.getLog((String)"solidyne").trace("Handling disable");
                comm.stopped();
            }
        }
        catch (Exception exc) {
            Log.getLog((String)"solidyne").error("Error closing comm port.");
            exc.printStackTrace();
        }
    }

    public Type getDeviceType() {
        return BSolidyneAbstractDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BSolidyneDeviceFolder.TYPE;
    }

    public BSolidyneAbstractDevice getDeviceByAddress(int targetAddr) {
        BSolidyneAbstractDevice toReturn = null;
        BDevice[] devs = this.getDevices();
        for (int i = 0; i < devs.length; ++i) {
            toReturn = (BSolidyneAbstractDevice)devs[i];
            if (((BSolidyneDeviceId)toReturn.getDeviceId()).getUnitNumber() != targetAddr) continue;
            return toReturn;
        }
        return null;
    }

    public void flagUnresponsiveDevices(int timeLimmit) {
        BDevice[] devs = this.getDevices();
        for (int i = 0; i < devs.length; ++i) {
            if (!(devs[i] instanceof BSolidyneAbstractDevice)) continue;
            ((BSolidyneAbstractDevice)devs[i]).pingFail("Too long since last message.");
        }
    }

    protected final void checkLicense() {
        String hostId = Sys.getHostId();
        String lastPart = hostId.substring(hostId.length() - 9, hostId.length() - 5) + hostId.substring(hostId.length() - 4, hostId.length());
        String x = "";
        for (int i = 0; i < lastPart.length(); ++i) {
            String c = lastPart.substring(i, i + 1);
            int j = Integer.parseInt(c, 16);
            x = x + "DFZCQXUNIBVMGJAT".charAt(j);
        }
        if (this.getCode().equalsIgnoreCase(x)) {
            licensed = true;
            demoMode = false;
            this.setLicenseStatus("Licensed.");
        } else {
            licensed = false;
            long now = new Date().getTime();
            if (now - stationStart > 0x6DDD00L) {
                if (demoMode) {
                    Log.getLog((String)"solidyne").message("solidyne driver 120 minute trial mode has expired.");
                }
                demoMode = false;
                licensed = false;
                this.setEnabled(false);
                this.setLicenseStatus("Trial mode has expired.");
            } else {
                if (!demoMode) {
                    Log.getLog((String)"solidyne").message("solidyne driver is not licensed to run on this station");
                    Log.getLog((String)"solidyne").message("solidyne driver trial mode started.");
                }
                demoMode = true;
                licensed = false;
                this.setLicenseStatus("120 minute trial mode is active.");
            }
        }
    }
}

