/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm;

import com.solidyne.solidyne.util.Utils;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddfSerial.comm.BDdfSerialReceiver;
import javax.baja.log.Log;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidyneReceiver
extends BDdfSerialReceiver {
    public static final Property maxFrameSize = BSolidyneReceiver.newProperty((int)0, (int)1050, null);
    public static final Type TYPE = Sys.loadType(BSolidyneReceiver.class);
    private static char BEGIN_CHAR = (char)127;

    public int getMaxFrameSize() {
        return this.getInt(maxFrameSize);
    }

    public void setMaxFrameSize(int v) {
        this.setInt(maxFrameSize, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int isStartOfFrame(IDdfDataFrame frameSoFar) {
        if (frameSoFar.getFrameBytes()[0] == BEGIN_CHAR) {
            return 0;
        }
        return 1;
    }

    public boolean isCompleteFrame(IDdfDataFrame frameSoFar) {
        byte[] unescapedFrame = Utils.unescapeMessage(frameSoFar.getFrameBytes(), frameSoFar.getFrameSize());
        if (unescapedFrame.length < 7) {
            return false;
        }
        int expectedMessageLen = unescapedFrame[4] * 256 + unescapedFrame[5];
        return unescapedFrame.length >= (expectedMessageLen = Math.min(expectedMessageLen, this.getMaxFrameSize())) + 7;
    }

    public boolean checkFrame(IDdfDataFrame frameSoFar) {
        byte[] unescapedFrame = Utils.unescapeMessage(frameSoFar.getFrameBytes(), frameSoFar.getFrameSize());
        byte checksum = 0;
        int expectedMessageLen = unescapedFrame[4] * 256 + unescapedFrame[5];
        if (unescapedFrame.length != expectedMessageLen + 7) {
            String logMsg = "Received invalid frame:";
            for (int i = 0; i < unescapedFrame.length; ++i) {
                String hexString = "0" + Integer.toHexString(unescapedFrame[i]);
                logMsg = logMsg + " " + hexString.substring(hexString.length() - 2);
            }
            Log.getLog((String)"solidyne").trace(logMsg);
            return false;
        }
        int posOfChecksum = expectedMessageLen + 6;
        for (int i = 0; i < posOfChecksum; ++i) {
            checksum = (byte)(checksum + unescapedFrame[i]);
        }
        if (unescapedFrame[unescapedFrame.length - 1] == checksum) {
            String logMsg = "Received valid frame:";
            for (int i = 0; i < unescapedFrame.length; ++i) {
                String hexString = "0" + Integer.toHexString(unescapedFrame[i]);
                logMsg = logMsg + " " + hexString.substring(hexString.length() - 2);
            }
            Log.getLog((String)"solidyne").trace(logMsg);
            return true;
        }
        String logMsg = "Received invalid frame:";
        for (int i = 0; i < unescapedFrame.length; ++i) {
            String hexString = "0" + Integer.toHexString(unescapedFrame[i]);
            logMsg = logMsg + " " + hexString.substring(hexString.length() - 2);
        }
        Log.getLog((String)"solidyne").trace(logMsg);
        return false;
    }
}

