/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm.req;

import com.solidyne.solidyne.BSolidyneAbstractDevice;
import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.comm.req.BSolidynePutForcedRequest;
import com.solidyne.solidyne.comm.rsp.BSolidyneGetForcedResponse;
import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.solidyne.solidyne.comm.rsp.SolidyneMessageFactory;
import com.solidyne.solidyne.identify.BSolidyneDeviceId;
import com.solidyne.solidyne.identify.BSolidynePointId;
import com.solidyne.solidyne.identify.BSolidynePortTypeEnum;
import com.solidyne.solidyne.point.BSolidyneAbstractProxyExt;
import com.solidyne.solidyne.util.Utils;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BDdfPingRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.BIDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfPingable;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.identify.BDdfIdParams;
import javax.baja.driver.BDevice;
import javax.baja.log.Log;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidyneGetForcedRequest
extends BDdfPingRequest
implements BIDdfWriteRequest {
    public static final Property portType = BSolidyneGetForcedRequest.newProperty((int)0, (BValue)BSolidynePortTypeEnum.Virtual, null);
    public static final Property portNumber = BSolidyneGetForcedRequest.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BSolidyneGetForcedRequest.class);
    protected int targetDevice;
    protected BSolidynePortTypeEnum targetPointType;
    protected int targetPoint;
    protected boolean forcedState;
    protected int value;
    public static byte ACTION_CANCEL = 0;
    public static byte ACTION_TRIGGER = 1;
    public static byte ACTION_QUERY = (byte)-1;
    protected BSolidyneAbstractProxyExt myProxy;
    protected byte targetPoint_h;
    protected byte targetPoint_l;
    protected byte newVal_h;
    protected byte newVal_l;
    protected boolean thisRequestWasCreatedExplicitly = false;
    IDdfWritable[] writableSource;
    BDdfIdParams requestId;

    public BSolidynePortTypeEnum getPortType() {
        return (BSolidynePortTypeEnum)this.get(portType);
    }

    public void setPortType(BSolidynePortTypeEnum v) {
        this.set(portType, (BValue)v, null);
    }

    public int getPortNumber() {
        return this.getInt(portNumber);
    }

    public void setPortNumber(int v) {
        this.setInt(portNumber, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSolidyneGetForcedRequest() {
        this.myProxy = null;
    }

    public BSolidyneGetForcedRequest(BSolidyneAbstractProxyExt prox, int targetDevice, boolean forcedState) {
        this(prox, targetDevice, forcedState, 0);
    }

    public BSolidyneGetForcedRequest(BSolidyneAbstractProxyExt prox, int targetDevice, boolean forcedState, int value) {
        BSolidynePointId id = (BSolidynePointId)prox.getPointId();
        this.myProxy = prox;
        this.targetDevice = targetDevice;
        this.targetPointType = prox.getPortType();
        this.targetPoint = id.getPortNumber();
        this.forcedState = forcedState;
        this.value = value;
        this.thisRequestWasCreatedExplicitly = true;
    }

    public void setAllAddresses() {
        this.targetDevice = ((BSolidyneDeviceId)this.getDeviceId()).getUnitNumber();
        this.value = (int)this.getRawValue((IDdfWritable)this.myProxy);
        BSolidynePointId id = (BSolidynePointId)this.myProxy.getPointId();
        this.targetPointType = this.myProxy.getPortType();
        this.targetPoint = id.getPortNumber();
        this.forcedState = !Utils.getPrioLevel(this.myProxy).equalsIgnoreCase("def");
    }

    protected double getRawValue(IDdfWritable ddfWritable) {
        BStatusValue writeValue = ddfWritable.getWriteValue();
        if (writeValue instanceof BStatusNumeric) {
            return ((BStatusNumeric)writeValue).getNumeric();
        }
        if (writeValue instanceof BStatusEnum) {
            return ((BStatusEnum)writeValue).getEnum().getOrdinal();
        }
        if (writeValue instanceof BStatusBoolean) {
            return ((BStatusBoolean)writeValue).getBoolean() ? 1.0 : 0.0;
        }
        if (writeValue instanceof BStatusString) {
            String s = ((BStatusString)writeValue).getValue();
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe1) {
                try {
                    int radix = this.getWritableSource()[0].getFacets().geti("radix", 10);
                    return (int)Long.parseLong(s, radix);
                }
                catch (NumberFormatException nfe2) {
                    String trueText;
                    BEnumRange range = (BEnumRange)this.getWritableSource()[0].getFacets().get("range", null);
                    if (range != null) {
                        try {
                            return range.tagToOrdinal(s);
                        }
                        catch (InvalidEnumException invalidEnumException) {
                            // empty catch block
                        }
                    }
                    if (s.equals(trueText = this.getWritableSource()[0].getFacets().gets("trueText", "True"))) {
                        return 1.0;
                    }
                    String falseText = this.getWritableSource()[0].getFacets().gets("falseText", "False");
                    if (s.equals(falseText)) {
                        return 0.0;
                    }
                    throw new BajaRuntimeException(DdfDefaultCommLexicon.unsupportedStringFormat((String)this.getWritableSource()[0].toString(), (String)s));
                }
            }
        }
        throw new BajaRuntimeException(DdfDefaultCommLexicon.unsupportedStringFormat((String)this.getWritableSource()[0].toString(), (String)this.getWritableSource()[0].getWriteValue().toString()));
    }

    public byte[] toByteArray() {
        byte[] msg;
        int hostAddress;
        if (!this.thisRequestWasCreatedExplicitly && this.myProxy != null) {
            this.setAllAddresses();
        }
        if (this.myProxy == null) {
            BSolidyneDeviceId deviceId = (BSolidyneDeviceId)this.getDeviceId();
            this.targetDevice = deviceId.getUnitNumber();
            hostAddress = deviceId.getHostDeviceAddress();
        } else {
            BSolidyneNetwork net = (BSolidyneNetwork)this.myProxy.getNetwork();
            hostAddress = ((BSolidyneCommunicator)net.getCommunicator()).getHostDeviceAddress();
        }
        int extendedMsgOffset = 0;
        if (this.targetDevice < 256) {
            msg = new byte[]{127, 0, 0, 28, 0, 0, 0};
            msg[1] = (byte)hostAddress;
            msg[2] = (byte)this.targetDevice;
        } else {
            msg = new byte[]{127, 0, 0, 28, 0, 5, 0, 0, 0, 0, 0, 0};
            msg[7] = 0;
            msg[8] = (byte)hostAddress;
            msg[9] = (byte)(this.targetDevice >> 8 & 0xFF);
            msg[10] = (byte)(this.targetDevice & 0xFF);
            extendedMsgOffset = 5;
        }
        byte checksum = 0;
        for (int i = 0; i < msg.length - 1; ++i) {
            checksum = (byte)(checksum + msg[i]);
        }
        msg[msg.length - 1] = checksum;
        return Utils.escapeMessage(msg);
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        block7: {
            try {
                BSolidyneResponse msg = SolidyneMessageFactory.makeMessage(iDdfDataFrame);
                if (msg.msgType != 156) break block7;
                Log.getLog((String)"solidyne").trace("RECEIVED FORCED_IO_STATES RESPONSE!!!" + (this.myProxy == null));
                BSolidyneGetForcedResponse resp = (BSolidyneGetForcedResponse)msg;
                if (this.myProxy != null) {
                    this.value = Math.min(100, this.value);
                    this.value = Math.max(0, this.value);
                    BSolidynePutForcedRequest req = new BSolidynePutForcedRequest(this.myProxy, this.targetDevice, this.targetPointType, this.targetPoint, this.forcedState, this.value, resp);
                    this.myProxy.getDdfCommunicator().communicate((BIDdfRequest)req);
                }
                if (this.myProxy == null) {
                    IDdfPingable[] devs = this.getPingableSource();
                    for (int i = 0; i < devs.length; ++i) {
                        if (!(devs[i] instanceof BSolidyneAbstractDevice)) continue;
                        ((BSolidyneAbstractDevice)devs[i]).handleMessage(resp);
                    }
                } else {
                    BSolidyneAbstractDevice dev = (BSolidyneAbstractDevice)this.myProxy.getDdfDevice();
                    BSolidyneNetwork net = (BSolidyneNetwork)dev.getNetwork();
                    BDevice[] devArray = net.getDevices();
                    for (int i = 0; i < devArray.length; ++i) {
                        BSolidyneDeviceId devId = (BSolidyneDeviceId)((BSolidyneAbstractDevice)devArray[i]).getDeviceId();
                        if (devId.getUnitNumber() != msg.orgDevice) continue;
                        ((BSolidyneAbstractDevice)devArray[i]).handleMessage(resp);
                    }
                }
                return resp;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new DdfResponseException();
            }
        }
        return null;
    }

    public boolean getAutoPingOk() {
        IDdfPingable[] pingableSource = this.getPingableSource();
        if (pingableSource != null) {
            for (int i = 0; i < pingableSource.length; ++i) {
                pingableSource[i].pingOk();
            }
        }
        return false;
    }

    public boolean getAutoPingOkLate() {
        IDdfPingable[] pingableSource = this.getPingableSource();
        if (pingableSource != null) {
            for (int i = 0; i < pingableSource.length; ++i) {
                pingableSource[i].pingOk();
            }
        }
        return false;
    }

    public boolean isGroupable() {
        return false;
    }

    public BDdfIdParams getWriteParameters() {
        return this.requestId;
    }

    public void setWriteParameters(BDdfIdParams requestId) {
        this.requestId = requestId;
    }

    public IDdfWritable[] getWritableSource() {
        return this.writableSource;
    }

    public void setWritableSource(IDdfWritable[] writableSource) {
        this.writableSource = writableSource;
        if (writableSource.length > 0 && writableSource[0] instanceof BSolidyneAbstractProxyExt) {
            this.myProxy = (BSolidyneAbstractProxyExt)writableSource[0];
        }
    }

    public boolean getAutoWriteOk() {
        return false;
    }

    public boolean getAutoWriteOkLate() {
        return false;
    }

    public boolean getAutoWriteFailOnTimeout() {
        return false;
    }

    public boolean getAutoWriteFailOnError() {
        return false;
    }

    public void setDeviceId(BDdfIdParams di) {
        super.setDeviceId(di);
    }
}

