/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm.rsp;

import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.tridium.ndriver.io.TypedInputStream;
import java.io.InputStream;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidynePublishedSensorValuesMessage
extends BSolidyneResponse {
    public static final Type TYPE = Sys.loadType(BSolidynePublishedSensorValuesMessage.class);
    public boolean[] outputState;
    public boolean[] outputOverride;
    public boolean[] sensorOverride;
    public boolean[] globalOvrdTrigger;
    public boolean[] globalOvrdCancel;
    public float[] avgInput;
    public float[] instInput;
    public float[] virtual;
    public float[] analogOutput;
    private boolean[] A_present;
    private boolean[] I_present;
    private boolean[] V_present;
    private boolean[] P_present;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BSolidynePublishedSensorValuesMessage() {
    }

    public BSolidynePublishedSensorValuesMessage(InputStream in) throws Exception {
        super(in);
        int i;
        TypedInputStream tin = (TypedInputStream)in;
        tin.skip((long)this.dataStart);
        int outputStates = tin.readUnsigned8();
        this.outputState = new boolean[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            this.outputState[7 - i2] = (outputStates & 1 << i2) != 0;
        }
        int outputOvrdStates = tin.readUnsigned8();
        this.outputOverride = new boolean[8];
        for (int i3 = 7; i3 >= 0; --i3) {
            this.outputOverride[7 - i3] = (outputOvrdStates & 1 << i3) != 0;
        }
        int sensorOvrdStates = tin.readUnsigned8();
        this.sensorOverride = new boolean[8];
        for (int i4 = 7; i4 >= 0; --i4) {
            this.sensorOverride[7 - i4] = (sensorOvrdStates & 1 << i4) != 0;
        }
        int globalOvrdTriggers = tin.readUnsigned8();
        this.globalOvrdTrigger = new boolean[8];
        for (int i5 = 7; i5 >= 0; --i5) {
            this.globalOvrdTrigger[7 - i5] = (globalOvrdTriggers & 1 << i5) != 0;
        }
        int globalOvrdCancels = tin.readUnsigned8();
        this.globalOvrdCancel = new boolean[8];
        for (int i6 = 7; i6 >= 0; --i6) {
            this.globalOvrdCancel[7 - i6] = (globalOvrdCancels & 1 << i6) != 0;
        }
        int A = tin.readUnsigned8();
        this.A_present = new boolean[8];
        for (int i7 = 7; i7 >= 0; --i7) {
            this.A_present[7 - i7] = (A & 1 << i7) != 0;
        }
        int I = tin.readUnsigned8();
        this.I_present = new boolean[8];
        for (int i8 = 7; i8 >= 0; --i8) {
            this.I_present[7 - i8] = (I & 1 << i8) != 0;
        }
        int V = tin.readUnsigned8();
        this.V_present = new boolean[8];
        for (int i9 = 7; i9 >= 0; --i9) {
            this.V_present[7 - i9] = (V & 1 << i9) != 0;
        }
        int P = tin.readUnsigned8();
        this.P_present = new boolean[8];
        for (i = 7; i >= 0; --i) {
            this.P_present[7 - i] = (P & 1 << i) != 0;
        }
        this.avgInput = new float[16];
        for (i = 0; i < 8; ++i) {
            this.avgInput[i] = this.A_present[i] ? (float)tin.readSigned16() / 8.0f : Float.NaN;
        }
        this.instInput = new float[16];
        for (i = 0; i < 8; ++i) {
            this.instInput[i] = this.I_present[i] ? (float)tin.readSigned16() / 8.0f : Float.NaN;
        }
        this.virtual = new float[16];
        for (i = 0; i < 8; ++i) {
            this.virtual[i] = this.V_present[i] ? (float)tin.readSigned16() / 8.0f : Float.NaN;
        }
        this.analogOutput = new float[16];
        for (i = 0; i < 8; ++i) {
            this.analogOutput[i] = this.P_present[i] ? (float)tin.readSigned16() / 8.0f : Float.NaN;
        }
    }
}

