/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.izac;

import com.solidyne.solidyne.BSolidyneAbstractDevice;
import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.comm.rsp.BSolidyneGetForcedResponse;
import com.solidyne.solidyne.comm.rsp.BSolidynePublishedExtendedVirtualSensorValuesMessage;
import com.solidyne.solidyne.comm.rsp.BSolidynePublishedSensorValuesMessage;
import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.solidyne.solidyne.identify.BSolidyneDeviceId;
import com.solidyne.solidyne.izac.BSolidyneIzacAnalogOutput;
import com.solidyne.solidyne.izac.BSolidyneIzacAnalogOutputs;
import com.solidyne.solidyne.izac.BSolidyneIzacDigitalOutput;
import com.solidyne.solidyne.izac.BSolidyneIzacDigitalOutputs;
import com.solidyne.solidyne.izac.BSolidyneIzacPointDeviceExt;
import com.solidyne.solidyne.izac.BSolidyneIzacSensorInput;
import com.solidyne.solidyne.izac.BSolidyneIzacSensorInputs;
import com.solidyne.solidyne.izac.BSolidyneIzacVirtual;
import com.solidyne.solidyne.izac.BSolidyneIzacVirtuals;
import com.solidyne.solidyne.izac.point.BSolidyneIzacProxyExt;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidyneIzacDevice
extends BSolidyneAbstractDevice {
    public static final Property points = BSolidyneIzacDevice.newProperty((int)0, (BValue)new BSolidyneIzacPointDeviceExt(), null);
    public static final Property sensorInputs = BSolidyneIzacDevice.newProperty((int)0, (BValue)new BSolidyneIzacSensorInputs(), null);
    public static final Property virtualPoints = BSolidyneIzacDevice.newProperty((int)0, (BValue)new BSolidyneIzacVirtuals(), null);
    public static final Property analogOutputs = BSolidyneIzacDevice.newProperty((int)0, (BValue)new BSolidyneIzacAnalogOutputs(), null);
    public static final Property digitalOutputs = BSolidyneIzacDevice.newProperty((int)0, (BValue)new BSolidyneIzacDigitalOutputs(), null);
    public static final Type TYPE = Sys.loadType(BSolidyneIzacDevice.class);
    Vector subscribedPoints = new Vector();

    public BSolidyneIzacPointDeviceExt getPoints() {
        return (BSolidyneIzacPointDeviceExt)this.get(points);
    }

    public void setPoints(BSolidyneIzacPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public BSolidyneIzacSensorInputs getSensorInputs() {
        return (BSolidyneIzacSensorInputs)this.get(sensorInputs);
    }

    public void setSensorInputs(BSolidyneIzacSensorInputs v) {
        this.set(sensorInputs, (BValue)v, null);
    }

    public BSolidyneIzacVirtuals getVirtualPoints() {
        return (BSolidyneIzacVirtuals)this.get(virtualPoints);
    }

    public void setVirtualPoints(BSolidyneIzacVirtuals v) {
        this.set(virtualPoints, (BValue)v, null);
    }

    public BSolidyneIzacAnalogOutputs getAnalogOutputs() {
        return (BSolidyneIzacAnalogOutputs)this.get(analogOutputs);
    }

    public void setAnalogOutputs(BSolidyneIzacAnalogOutputs v) {
        this.set(analogOutputs, (BValue)v, null);
    }

    public BSolidyneIzacDigitalOutputs getDigitalOutputs() {
        return (BSolidyneIzacDigitalOutputs)this.get(digitalOutputs);
    }

    public void setDigitalOutputs(BSolidyneIzacDigitalOutputs v) {
        this.set(digitalOutputs, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void doPing() {
        BSolidyneNetwork net = (BSolidyneNetwork)this.getNetwork();
        BSolidyneCommunicator comm = (BSolidyneCommunicator)net.getCommunicator();
        int inactivityTimeout = comm.getInactivityTimeout();
        BAbsTime lastOk = this.getHealth().getLastOkTime();
        BAbsTime now = BAbsTime.make();
        long timeSinceLastOk = now.getMillis() - lastOk.getMillis();
        if (timeSinceLastOk > (long)inactivityTimeout) {
            this.pingFail("Too long since last message.");
        } else {
            this.pingOk();
        }
    }

    public BSolidyneIzacDevice() {
    }

    public BSolidyneIzacDevice(int address) {
        ((BSolidyneDeviceId)this.getDeviceId()).setUnitNumber(address);
    }

    public void started() throws Exception {
        BSolidyneNetwork net = (BSolidyneNetwork)this.getNetwork();
        BSolidyneCommunicator comm = (BSolidyneCommunicator)net.getCommunicator();
        int hostAddress = comm.getHostDeviceAddress();
        ((BSolidyneDeviceId)this.getDeviceId()).setHostDeviceAddress(hostAddress);
    }

    @Override
    public Type getNetworkType() {
        return BSolidyneNetwork.TYPE;
    }

    @Override
    public void handleMessage(BSolidyneResponse msg) {
        Log.getLog((String)"solidyne").trace("Device handling messge. Type=" + msg.msgType);
        this.pingOk();
        Log.getLog((String)"solidyne").trace("SolidyneIzacDevice: handleMessage " + msg.msgType);
        switch (msg.msgType) {
            case 71: {
                this.processPublishedSensorValuesMsg((BSolidynePublishedSensorValuesMessage)msg);
                break;
            }
            case 111: {
                this.processPublishedExtendedVirtualSensorValuesMsg((BSolidynePublishedExtendedVirtualSensorValuesMessage)msg);
                break;
            }
            case 156: {
                this.processGetForcedStatesAndValuesMsg((BSolidyneGetForcedResponse)msg);
            }
        }
        this.updateProxies();
    }

    public void processGetForcedStatesAndValuesMsg(BSolidyneGetForcedResponse msg) {
    }

    public void processPublishedSensorValuesMsg(BSolidynePublishedSensorValuesMessage msg) {
        int i;
        for (i = 0; i < 8; ++i) {
            ((BSolidyneIzacSensorInput)this.getSensorInputs().get("s" + (i + 1))).setAverage(new BStatusNumeric((double)msg.avgInput[i]));
            ((BSolidyneIzacSensorInput)this.getSensorInputs().get("s" + (i + 1))).setInstantaneous(new BStatusNumeric((double)msg.instInput[i]));
            ((BSolidyneIzacSensorInput)this.getSensorInputs().get("s" + (i + 1))).setOverridden(msg.sensorOverride[i]);
        }
        for (i = 0; i < 8; ++i) {
            ((BSolidyneIzacVirtual)this.getVirtualPoints().get("v" + (i + 1))).setValue(new BStatusNumeric((double)msg.virtual[i]));
        }
        for (i = 0; i < 8; ++i) {
            ((BSolidyneIzacAnalogOutput)this.getAnalogOutputs().get("ao" + (i + 1))).setValue(new BStatusNumeric((double)msg.analogOutput[i]));
        }
        for (i = 0; i < 8; ++i) {
            ((BSolidyneIzacDigitalOutput)this.getDigitalOutputs().get("do" + (i + 1))).setValue(new BStatusBoolean(msg.outputState[i]));
            ((BSolidyneIzacDigitalOutput)this.getDigitalOutputs().get("do" + (i + 1))).setValueOverridden(msg.outputOverride[i]);
        }
    }

    public void processPublishedExtendedVirtualSensorValuesMsg(BSolidynePublishedExtendedVirtualSensorValuesMessage msg) {
    }

    protected void updateProxies() {
        BComponentSpace space = this.getComponentSpace();
        Log.getLog((String)"solidyne").trace("Updating proxies " + this.subscribedPoints.size());
        for (int i = 0; i < this.subscribedPoints.size(); ++i) {
            BComponent comp = space.findByHandle(this.subscribedPoints.get(i));
            if (!(comp instanceof BSolidyneIzacProxyExt)) continue;
            BSolidyneIzacProxyExt prox = (BSolidyneIzacProxyExt)comp;
            prox.readOk();
        }
    }

    public void registerProxy(BSolidyneIzacProxyExt prox) {
        Log.getLog((String)"solidyne").trace("Registering proxy");
        this.subscribedPoints.add(prox.getHandle());
        this.updateProxies();
    }

    public void unregisterProxy(BSolidyneIzacProxyExt prox) {
        for (int i = this.subscribedPoints.size() - 1; i >= 0; --i) {
            if (!prox.getHandle().equals(this.subscribedPoints.get(i))) continue;
            this.subscribedPoints.remove(i);
        }
    }
}

