/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne;

import com.solidyne.solidyne.BSolidyneAbstractDevice;
import com.solidyne.solidyne.BSolidyneAnalogOutput;
import com.solidyne.solidyne.BSolidyneAnalogOutputs;
import com.solidyne.solidyne.BSolidyneDigitalOutput;
import com.solidyne.solidyne.BSolidyneDigitalOutputs;
import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.BSolidynePointDeviceExt;
import com.solidyne.solidyne.BSolidyneSensorInput;
import com.solidyne.solidyne.BSolidyneSensorInputs;
import com.solidyne.solidyne.BSolidyneVirtual;
import com.solidyne.solidyne.BSolidyneVirtuals;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.comm.rsp.BSolidyneGetForcedResponse;
import com.solidyne.solidyne.comm.rsp.BSolidynePublishedExtendedVirtualSensorValuesMessage;
import com.solidyne.solidyne.comm.rsp.BSolidynePublishedSensorValuesMessage;
import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.solidyne.solidyne.identify.BSolidyneDeviceId;
import com.solidyne.solidyne.point.BSolidyneProxyExt;
import com.tridium.ddf.point.BDdfProxyExt;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidyneDevice
extends BSolidyneAbstractDevice {
    public static final Property points = BSolidyneDevice.newProperty((int)0, (BValue)new BSolidynePointDeviceExt(), null);
    public static final Property sensorInputs = BSolidyneDevice.newProperty((int)0, (BValue)new BSolidyneSensorInputs(), null);
    public static final Property virtualPoints = BSolidyneDevice.newProperty((int)0, (BValue)new BSolidyneVirtuals(), null);
    public static final Property analogOutputs = BSolidyneDevice.newProperty((int)0, (BValue)new BSolidyneAnalogOutputs(), null);
    public static final Property digitalOutputs = BSolidyneDevice.newProperty((int)0, (BValue)new BSolidyneDigitalOutputs(), null);
    public static final Type TYPE = Sys.loadType(BSolidyneDevice.class);
    Vector subscribedPoints = new Vector();

    public BSolidynePointDeviceExt getPoints() {
        return (BSolidynePointDeviceExt)this.get(points);
    }

    public void setPoints(BSolidynePointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public BSolidyneSensorInputs getSensorInputs() {
        return (BSolidyneSensorInputs)this.get(sensorInputs);
    }

    public void setSensorInputs(BSolidyneSensorInputs v) {
        this.set(sensorInputs, (BValue)v, null);
    }

    public BSolidyneVirtuals getVirtualPoints() {
        return (BSolidyneVirtuals)this.get(virtualPoints);
    }

    public void setVirtualPoints(BSolidyneVirtuals v) {
        this.set(virtualPoints, (BValue)v, null);
    }

    public BSolidyneAnalogOutputs getAnalogOutputs() {
        return (BSolidyneAnalogOutputs)this.get(analogOutputs);
    }

    public void setAnalogOutputs(BSolidyneAnalogOutputs v) {
        this.set(analogOutputs, (BValue)v, null);
    }

    public BSolidyneDigitalOutputs getDigitalOutputs() {
        return (BSolidyneDigitalOutputs)this.get(digitalOutputs);
    }

    public void setDigitalOutputs(BSolidyneDigitalOutputs v) {
        this.set(digitalOutputs, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BSolidyneDevice() {
    }

    public BSolidyneDevice(int address) {
        ((BSolidyneDeviceId)this.getDeviceId()).setUnitNumber(address);
    }

    public void started() throws Exception {
        BSolidyneNetwork net = (BSolidyneNetwork)this.getNetwork();
        BSolidyneCommunicator comm = (BSolidyneCommunicator)net.getCommunicator();
        int hostAddress = comm.getHostDeviceAddress();
        ((BSolidyneDeviceId)this.getDeviceId()).setHostDeviceAddress(hostAddress);
    }

    @Override
    public Type getNetworkType() {
        return BSolidyneNetwork.TYPE;
    }

    @Override
    public void handleMessage(BSolidyneResponse msg) {
        Log.getLog((String)"solidyne").trace("Device handling messge. Type=" + msg.msgType);
        this.pingOk();
        switch (msg.msgType) {
            case 71: {
                this.processPublishedSensorValuesMsg((BSolidynePublishedSensorValuesMessage)msg);
                break;
            }
            case 111: {
                this.processPublishedExtendedVirtualSensorValuesMsg((BSolidynePublishedExtendedVirtualSensorValuesMessage)msg);
                break;
            }
            case 156: {
                this.processGetForcedStatesAndValuesMsg((BSolidyneGetForcedResponse)msg);
            }
        }
        this.updateProxies();
    }

    public void processGetForcedStatesAndValuesMsg(BSolidyneGetForcedResponse msg) {
        for (int i = 0; i < 8; ++i) {
            ((BSolidyneSensorInput)this.getSensorInputs().get("s" + (i + 1))).setForced(msg.inputForced[i]);
            ((BSolidyneDigitalOutput)this.getDigitalOutputs().get("do" + (i + 1))).setForced(msg.outputForced[i]);
            ((BSolidyneAnalogOutput)this.getAnalogOutputs().get("ao" + (i + 1))).setForced(msg.pwmForced[i]);
        }
    }

    public void processPublishedSensorValuesMsg(BSolidynePublishedSensorValuesMessage msg) {
        int i;
        for (i = 0; i < 8; ++i) {
            ((BSolidyneSensorInput)this.getSensorInputs().get("s" + (i + 1))).setAverage(new BStatusNumeric((double)msg.avgInput[i]));
            ((BSolidyneSensorInput)this.getSensorInputs().get("s" + (i + 1))).setInstantaneous(new BStatusNumeric((double)msg.instInput[i]));
            ((BSolidyneSensorInput)this.getSensorInputs().get("s" + (i + 1))).setOverridden(msg.sensorOverride[i]);
        }
        for (i = 0; i < 8; ++i) {
            ((BSolidyneVirtual)this.getVirtualPoints().get("v" + (i + 1))).setValue(new BStatusNumeric((double)msg.virtual[i]));
        }
        for (i = 0; i < 8; ++i) {
            ((BSolidyneAnalogOutput)this.getAnalogOutputs().get("ao" + (i + 1))).setValue(new BStatusNumeric((double)msg.analogOutput[i]));
        }
        for (i = 0; i < 8; ++i) {
            ((BSolidyneDigitalOutput)this.getDigitalOutputs().get("do" + (i + 1))).setValue(new BStatusBoolean(msg.outputState[i]));
            ((BSolidyneDigitalOutput)this.getDigitalOutputs().get("do" + (i + 1))).setValueOverridden(msg.outputOverride[i]);
        }
    }

    public void processPublishedExtendedVirtualSensorValuesMsg(BSolidynePublishedExtendedVirtualSensorValuesMessage msg) {
        for (int i = 0; i < 8; ++i) {
            ((BSolidyneVirtual)this.getVirtualPoints().get("v" + (i + 9))).setValue(new BStatusNumeric((double)msg.virtual[i]));
        }
    }

    protected void updateProxies() {
        if (BSolidyneNetwork.licensed || BSolidyneNetwork.demoMode) {
            BComponentSpace space = this.getComponentSpace();
            Log.getLog((String)"solidyne").trace("Updating proxies " + this.subscribedPoints.size());
            for (int i = 0; i < this.subscribedPoints.size(); ++i) {
                BComponent comp = space.findByHandle(this.subscribedPoints.get(i));
                if (!(comp instanceof BSolidyneProxyExt)) continue;
                BSolidyneProxyExt prox = (BSolidyneProxyExt)comp;
                prox.readOk();
            }
        }
        if (!BSolidyneNetwork.licensed || BSolidyneNetwork.demoMode) {
            BSolidyneNetwork net = (BSolidyneNetwork)this.getNetwork();
            net.checkLicense();
        }
    }

    public void registerProxy(BDdfProxyExt prox) {
        Log.getLog((String)"solidyne").trace("Registering proxy");
        this.subscribedPoints.add(prox.getHandle());
        this.updateProxies();
    }

    public void unregisterProxy(BDdfProxyExt prox) {
        for (int i = this.subscribedPoints.size() - 1; i >= 0; --i) {
            if (!prox.getHandle().equals(this.subscribedPoints.get(i))) continue;
            this.subscribedPoints.remove(i);
        }
    }
}

