/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm;

import com.solidyne.solidyne.BSolidyneAbstractDevice;
import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.solidyne.solidyne.comm.rsp.BSolidyneUnrecognizedMessage;
import com.solidyne.solidyne.comm.rsp.SolidyneMessageFactory;
import com.solidyne.solidyne.identify.BSolidyneDeviceId;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfUnsolicitedMgr;
import javax.baja.driver.BDevice;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidyneUnsolicitedMgr
extends BDdfUnsolicitedMgr {
    public static final Type TYPE = Sys.loadType(BSolidyneUnsolicitedMgr.class);

    public Type getType() {
        return TYPE;
    }

    public void processUnsolicitedFrame(IDdfDataFrame frame) throws Exception {
        BSolidyneCommunicator comm = (BSolidyneCommunicator)this.getDdfCommunicator();
        BSolidyneNetwork net = (BSolidyneNetwork)comm.getDdfSerialNetwork();
        BDevice[] devArray = net.getDevices();
        BSolidyneResponse msg = SolidyneMessageFactory.makeMessage(frame);
        String hexString = "0" + Integer.toHexString(msg.msgType);
        Log.getLog((String)"solidyne").trace("Unsolicited mgr message type=" + hexString.substring(hexString.length() - 2));
        comm.printWorkerState();
        if (!(msg instanceof BSolidyneUnrecognizedMessage)) {
            for (int i = 0; i < devArray.length; ++i) {
                BSolidyneDeviceId devId = (BSolidyneDeviceId)((BSolidyneAbstractDevice)devArray[i]).getDeviceId();
                if (devId.getUnitNumber() != msg.orgDevice) continue;
                ((BSolidyneAbstractDevice)devArray[i]).handleMessage(msg);
            }
            ((BSolidyneCommunicator)this.getDdfCommunicator()).setLastUnsolicitedMsg(BAbsTime.make());
        }
    }
}

