/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm.req;

import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.comm.rsp.BSolidyneGetForcedResponse;
import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.solidyne.solidyne.comm.rsp.SolidyneMessageFactory;
import com.solidyne.solidyne.identify.BSolidynePortTypeEnum;
import com.solidyne.solidyne.point.BSolidyneAbstractProxyExt;
import com.solidyne.solidyne.util.Utils;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidynePutForcedRequest
extends BDdfRequest {
    public static final Type TYPE = Sys.loadType(BSolidynePutForcedRequest.class);
    protected int targetDevice;
    public boolean[] inputForced = new boolean[8];
    public boolean[] outputForced = new boolean[8];
    public boolean[] outputForcedValues = new boolean[8];
    public boolean[] pwmForced = new boolean[8];
    public int[] pwmForcedValues = new int[8];
    protected BSolidyneAbstractProxyExt myProxy;

    public Type getType() {
        return TYPE;
    }

    public BSolidynePutForcedRequest() {
    }

    public BSolidynePutForcedRequest(BSolidyneAbstractProxyExt prox, int targetDevice, BSolidynePortTypeEnum targetPointType, int targetPoint, boolean forcedState, int value, BSolidyneGetForcedResponse resp) {
        this.myProxy = prox;
        this.targetDevice = targetDevice;
        for (int i = 0; i < 8; ++i) {
            this.inputForced[i] = resp.inputForced[i];
            this.outputForced[i] = resp.outputForced[i];
            this.outputForcedValues[i] = resp.outputForcedValues[i];
            this.pwmForced[i] = resp.pwmForced[i];
            this.pwmForcedValues[i] = resp.pwmForcedValues[i];
        }
        if (targetPointType == BSolidynePortTypeEnum.UniversalInput) {
            this.inputForced[targetPoint - 1] = forcedState;
        }
        if (targetPointType == BSolidynePortTypeEnum.DigitalOut) {
            this.outputForced[targetPoint - 1] = forcedState;
            boolean bl = this.outputForcedValues[targetPoint - 1] = value != 0;
        }
        if (targetPointType == BSolidynePortTypeEnum.AnalogOut) {
            this.pwmForced[targetPoint - 1] = forcedState;
            this.pwmForcedValues[targetPoint - 1] = value;
        }
    }

    public byte[] toByteArray() {
        int bit;
        byte[] msg;
        BSolidyneNetwork net = (BSolidyneNetwork)this.myProxy.getNetwork();
        int hostAddress = ((BSolidyneCommunicator)net.getCommunicator()).getHostDeviceAddress();
        int extendedMsgOffset = 0;
        if (this.targetDevice < 256) {
            msg = new byte[]{127, 0, 0, 62, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            msg[1] = (byte)hostAddress;
            msg[2] = (byte)this.targetDevice;
        } else {
            msg = new byte[]{127, 0, 0, 62, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            msg[7] = 0;
            msg[8] = (byte)hostAddress;
            msg[9] = (byte)(this.targetDevice >> 8 & 0xFF);
            msg[10] = (byte)(this.targetDevice & 0xFF);
            extendedMsgOffset = 5;
        }
        for (bit = 0; bit < 8; ++bit) {
            if (!this.inputForced[bit]) continue;
            int n = 6 + extendedMsgOffset;
            msg[n] = (byte)(msg[n] | 128 >> bit);
        }
        for (bit = 0; bit < 8; ++bit) {
            if (!this.outputForced[bit]) continue;
            int n = 7 + extendedMsgOffset;
            msg[n] = (byte)(msg[n] | 128 >> bit);
        }
        for (bit = 0; bit < 8; ++bit) {
            if (!this.outputForcedValues[bit]) continue;
            int n = 8 + extendedMsgOffset;
            msg[n] = (byte)(msg[n] | 128 >> bit);
        }
        for (bit = 0; bit < 8; ++bit) {
            if (!this.pwmForced[bit]) continue;
            int n = 9 + extendedMsgOffset;
            msg[n] = (byte)(msg[n] | 128 >> bit);
        }
        for (int i = 0; i < 8; ++i) {
            msg[10 + i + extendedMsgOffset] = (byte)(this.pwmForcedValues[i] & 0xFF);
        }
        byte checksum = 0;
        for (int i = 0; i < msg.length - 1; ++i) {
            checksum = (byte)(checksum + msg[i]);
        }
        msg[msg.length - 1] = checksum;
        return Utils.escapeMessage(msg);
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        try {
            BSolidyneResponse msg = SolidyneMessageFactory.makeMessage(iDdfDataFrame);
            if (msg.msgType == 190) {
                Log.getLog((String)"solidyne").trace("RECEIVED PUT FORCED RESPONSE!!!");
                return msg;
            }
        }
        catch (Exception exc) {
            throw new DdfResponseException();
        }
        return null;
    }
}

