/*
 * Decompiled with CFR 0.152.
 */
package com.solidyne.solidyne.comm.req;

import com.solidyne.solidyne.BSolidyneNetwork;
import com.solidyne.solidyne.comm.BSolidyneCommunicator;
import com.solidyne.solidyne.comm.rsp.BSolidyneResponse;
import com.solidyne.solidyne.comm.rsp.SolidyneMessageFactory;
import com.solidyne.solidyne.identify.BSolidyneDeviceId;
import com.solidyne.solidyne.identify.BSolidynePointId;
import com.solidyne.solidyne.identify.BSolidynePortTypeEnum;
import com.solidyne.solidyne.izac.point.BSolidyneIzacProxyExt;
import com.solidyne.solidyne.point.BSolidyneAbstractProxyExt;
import com.solidyne.solidyne.util.Utils;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.point.BDdfProxyExt;
import javax.baja.log.Log;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSolidyneSetRequest
extends BDdfWriteRequest {
    public static final Property portType = BSolidyneSetRequest.newProperty((int)0, (BValue)BSolidynePortTypeEnum.Virtual, null);
    public static final Property portNumber = BSolidyneSetRequest.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BSolidyneSetRequest.class);
    protected int targetDevice;
    protected byte targetPoint_h;
    protected byte targetPoint_l;
    protected byte newVal_h;
    protected byte newVal_l;
    protected double newVal;
    protected BDdfProxyExt myProxy;
    public static byte ACTION_CANCEL = 0;
    public static byte ACTION_TRIGGER = 1;
    public static byte ACTION_QUERY = (byte)-1;
    protected boolean thisRequestWasCreatedExplicitly = false;
    IDdfWritable[] writableSource;
    BDdfIdParams requestId;

    public BSolidynePortTypeEnum getPortType() {
        return (BSolidynePortTypeEnum)this.get(portType);
    }

    public void setPortType(BSolidynePortTypeEnum v) {
        this.set(portType, (BValue)v, null);
    }

    public int getPortNumber() {
        return this.getInt(portNumber);
    }

    public void setPortNumber(int v) {
        this.setInt(portNumber, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getTargetAddress() {
        BSolidynePointId id = (BSolidynePointId)this.myProxy.getPointId();
        String toReturn = Integer.toString(id.getPortNumber());
        return toReturn;
    }

    public BSolidyneSetRequest() {
        Log.getLog((String)"solidyne_virtualWrite").trace("Making non-explicit set request");
    }

    public BSolidyneSetRequest(BSolidyneAbstractProxyExt prox, int targetDevice, double newVal) {
        Log.getLog((String)"solidyne_virtualWrite").trace("Making normal set request");
        this.targetDevice = targetDevice;
        byte[] x = new byte[]{0, 0};
        BSolidynePointId id = (BSolidynePointId)prox.getPointId();
        if (prox.getPortType().equals((Object)BSolidynePortTypeEnum.UniversalInput)) {
            x = Utils.makeAddress(targetDevice, id.getPortNumber(), Utils.POINTTYPE_UI_AVG);
        }
        if (prox.getPortType().equals((Object)BSolidynePortTypeEnum.Virtual)) {
            x = id.getPortNumber() <= 8 ? Utils.makeAddress(targetDevice, id.getPortNumber(), Utils.POINTTYPE_VIRTUAL) : Utils.makeAddress(targetDevice, id.getPortNumber(), Utils.POINTTYPE_EXT_VIRTUAL);
        }
        if (prox.getPortType().equals((Object)BSolidynePortTypeEnum.AnalogOut)) {
            x = Utils.makeAddress(targetDevice, id.getPortNumber(), Utils.POINTTYPE_AO);
        }
        if (prox.getPortType().equals((Object)BSolidynePortTypeEnum.DigitalOut)) {
            x = Utils.makeAddress(targetDevice, id.getPortNumber(), Utils.POINTTYPE_DO);
        }
        this.myProxy = prox;
        this.targetPoint_h = x[0];
        this.targetPoint_l = x[1];
        byte[] y = Utils.encodeReal(newVal);
        this.newVal_h = y[0];
        this.newVal_l = y[1];
        this.thisRequestWasCreatedExplicitly = true;
    }

    public void setAllAddresses() {
        this.targetDevice = ((BSolidyneDeviceId)this.getDeviceId()).getUnitNumber();
        this.newVal = this.getRawValue((IDdfWritable)this.myProxy);
        BSolidynePointId id = (BSolidynePointId)this.myProxy.getPointId();
        BStatusValue writeValue = this.myProxy.getWriteValue();
        byte[] x = new byte[]{0, 0};
        Log.getLog((String)"solidyne").trace("setAllAddresses - pointType = " + (Object)((Object)id.getPointType()));
        BSolidynePortTypeEnum ptType = id.getPointType();
        if (ptType.equals((Object)BSolidynePortTypeEnum.UniversalInput) || ptType.equals((Object)BSolidynePortTypeEnum.IzacUniversalInput)) {
            x = Utils.makeAddress(this.targetDevice, id.getPortNumber(), Utils.POINTTYPE_UI_AVG);
        }
        if (ptType.equals((Object)BSolidynePortTypeEnum.Virtual) || ptType.equals((Object)BSolidynePortTypeEnum.IzacVirtual)) {
            x = id.getPortNumber() <= 8 ? Utils.makeAddress(this.targetDevice, id.getPortNumber(), Utils.POINTTYPE_VIRTUAL) : Utils.makeAddress(this.targetDevice, id.getPortNumber(), Utils.POINTTYPE_EXT_VIRTUAL);
        }
        if (ptType.equals((Object)BSolidynePortTypeEnum.AnalogOut) || ptType.equals((Object)BSolidynePortTypeEnum.IzacAnalogOut)) {
            x = Utils.makeAddress(this.targetDevice, id.getPortNumber(), Utils.POINTTYPE_AO);
        }
        if (ptType.equals((Object)BSolidynePortTypeEnum.DigitalOut) || ptType.equals((Object)BSolidynePortTypeEnum.IzacDigitalOut)) {
            x = Utils.makeAddress(this.targetDevice, id.getPortNumber(), Utils.POINTTYPE_DO);
        }
        this.targetPoint_h = x[0];
        this.targetPoint_l = x[1];
        byte[] y = Utils.encodeReal(this.newVal);
        this.newVal_h = y[0];
        this.newVal_l = y[1];
    }

    public BSolidyneSetRequest(BSolidyneIzacProxyExt prox, int targetDevice, double newVal) {
        Log.getLog((String)"solidyne_virtualWrite").trace("Making izac set request");
        this.targetDevice = targetDevice;
        byte[] x = new byte[]{0, 0};
        BSolidynePointId id = (BSolidynePointId)prox.getPointId();
        if (prox.getPortType().equals((Object)BSolidynePortTypeEnum.IzacUniversalInput)) {
            x = Utils.makeAddress(targetDevice, id.getPortNumber(), Utils.POINTTYPE_UI_AVG);
        }
        if (prox.getPortType().equals((Object)BSolidynePortTypeEnum.IzacVirtual)) {
            x = Utils.makeAddress(targetDevice, id.getPortNumber(), Utils.POINTTYPE_VIRTUAL);
        }
        if (prox.getPortType().equals((Object)BSolidynePortTypeEnum.IzacAnalogOut)) {
            x = Utils.makeAddress(targetDevice, id.getPortNumber(), Utils.POINTTYPE_AO);
        }
        if (prox.getPortType().equals((Object)BSolidynePortTypeEnum.IzacDigitalOut)) {
            x = Utils.makeAddress(targetDevice, id.getPortNumber(), Utils.POINTTYPE_DO);
        }
        this.myProxy = prox;
        this.targetPoint_h = x[0];
        this.targetPoint_l = x[1];
        byte[] y = Utils.encodeReal(newVal);
        this.newVal_h = y[0];
        this.newVal_l = y[1];
        this.thisRequestWasCreatedExplicitly = true;
    }

    public byte[] toByteArray() {
        byte[] msg;
        Log.getLog((String)"solidyne_virtualWrite").trace("PACKAGING SET REQUEST for " + this.myProxy.getDdfDevice().getNavName() + " to " + this.myProxy.getPointId().toString());
        if (!this.thisRequestWasCreatedExplicitly) {
            this.setAllAddresses();
        }
        BSolidyneNetwork net = (BSolidyneNetwork)this.myProxy.getNetwork();
        int hostAddress = ((BSolidyneCommunicator)net.getCommunicator()).getHostDeviceAddress();
        int extendedMsgOffset = 0;
        if (this.targetDevice < 256) {
            msg = new byte[]{127, 0, 0, 101, 0, 4, 0, 0, 0, 0, 0};
            msg[1] = (byte)hostAddress;
            msg[2] = (byte)this.targetDevice;
        } else {
            msg = new byte[]{127, 0, 0, 101, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            msg[7] = 0;
            msg[8] = (byte)hostAddress;
            msg[9] = (byte)(this.targetDevice >> 8 & 0xFF);
            msg[10] = (byte)(this.targetDevice & 0xFF);
            extendedMsgOffset = 5;
        }
        msg[6 + extendedMsgOffset] = this.targetPoint_h;
        msg[7 + extendedMsgOffset] = this.targetPoint_l;
        msg[8 + extendedMsgOffset] = this.newVal_h;
        msg[9 + extendedMsgOffset] = this.newVal_l;
        byte checksum = 0;
        for (int i = 0; i < msg.length - 1; ++i) {
            checksum = (byte)(checksum + msg[i]);
        }
        msg[msg.length - 1] = checksum;
        return Utils.escapeMessage(msg);
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        try {
            BSolidyneResponse msg = SolidyneMessageFactory.makeMessage(iDdfDataFrame);
            if (msg.msgType == 229) {
                Log.getLog((String)"solidyne_virtualWrite").trace("RECEIVED SET REQUEST RESPONSE!!!  for " + this.myProxy.getDdfDevice().getNavName() + " to " + this.myProxy.getPointId().toString());
                this.myProxy.writeOk(this.myProxy.getWriteValue());
                return msg;
            }
        }
        catch (Exception exc) {
            throw new DdfResponseException();
        }
        return null;
    }

    public boolean isGroupable() {
        return false;
    }

    public BDdfIdParams getWriteParameters() {
        return this.requestId;
    }

    public void setWriteParameters(BDdfIdParams requestId) {
        this.requestId = requestId;
    }

    public IDdfWritable[] getWritableSource() {
        return this.writableSource;
    }

    public void setWritableSource(IDdfWritable[] writableSource) {
        this.writableSource = writableSource;
        if (writableSource.length > 0 && writableSource[0] instanceof BSolidyneAbstractProxyExt) {
            this.myProxy = (BSolidyneAbstractProxyExt)writableSource[0];
        }
    }

    public boolean getAutoWriteOk() {
        return true;
    }

    public boolean getAutoWriteOkLate() {
        return false;
    }

    public boolean getAutoWriteFailOnTimeout() {
        return false;
    }

    public boolean getAutoWriteFailOnError() {
        return false;
    }

    public void setDeviceId(BDdfIdParams di) {
        super.setDeviceId(di);
    }
}

